/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.backends.pascal;

import com.inprise.vbroker.compiler.ast.AliasNode;
import com.inprise.vbroker.compiler.ast.ConstantNode;
import com.inprise.vbroker.compiler.ast.ContainedNode;
import com.inprise.vbroker.compiler.ast.ContainerNode;
import com.inprise.vbroker.compiler.ast.EnumNode;
import com.inprise.vbroker.compiler.ast.ExceptionNode;
import com.inprise.vbroker.compiler.ast.InterfaceNode;
import com.inprise.vbroker.compiler.ast.ModuleNode;
import com.inprise.vbroker.compiler.ast.Node;
import com.inprise.vbroker.compiler.ast.PrimitiveNode;
import com.inprise.vbroker.compiler.ast.RepositoryNode;
import com.inprise.vbroker.compiler.ast.StructNode;
import com.inprise.vbroker.compiler.ast.Type;
import com.inprise.vbroker.compiler.ast.UnionNode;
import com.inprise.vbroker.compiler.backends.common.GenericBackend;
import com.inprise.vbroker.compiler.backends.pascal.PascalBase;
import com.inprise.vbroker.compiler.backends.pascal.ast.PAliasNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.PArrayNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.PAttributeNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.PConstantNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.PEnumNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.PExceptionNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.PInterfaceNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.PMethod;
import com.inprise.vbroker.compiler.backends.pascal.ast.PModuleNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.POperationNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.PPrimitiveNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.PRepositoryNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.PSequenceNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.PStructNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.PType;
import com.inprise.vbroker.compiler.backends.pascal.ast.PUnionNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.PascalBeOptions;
import com.inprise.vbroker.compiler.util.BufferWriter;
import java.security.MessageDigest;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public final class PascalBackend
extends PascalBase {
    private int _pass;
    private final int COMMENT_LENGTH = 77;
    private static final int NUMBER_OF_PASSES = 4;
    private static final int PASCAL_I_FILE = 0;
    private static final int PASCAL_C_FILE = 1;
    private static final int PASCAL_S_FILE = 2;
    private static final int PASCAL_P_FILE = 3;
    private static final int GENERATE_I_FILE_DEFS = 11;
    private static final int GENERATE_I_GUID = 12;
    private static final int GENERATE_C_FILE_DEFS = 31;
    private static final int GENERATE_C_FILE_IMP = 32;
    private static final int GENERATE_C_STUB_IMP = 33;
    private static final int GENERATE_C_FILE_ADT_DEFS = 34;
    private static final int GENERATE_C_EXCEPTION_DEF = 35;
    private static final int GENERATE_C_EXCEPTION_IMP = 36;
    private static final int GENERATE_S_FILE_DEFS = 51;
    private static final int GENERATE_S_FILE_IMP = 52;
    private static final int GENERATE_S_EXCEPTION_DESCRIPTION = 53;
    private static final int GENERATE_S_EXCEPTION_HOOK_DESCRIPTION = 54;
    private static final int GENERATE_S_FILE_DESCRIPTION = 55;
    private static final int GENERATE_S_FILE_HOOK_DESCRIPTION = 56;
    private static final int GENERATE_S_SKELETON_IMP = 71;
    private static final int GENERATE_S_SKELETON_MARSHAL = 72;
    private static final int GENERATE_P_FILE_DEFS = 81;
    private static final int GENERATE_P_FILE_IMPL = 82;
    private static final int GENERATE_P_FILE_PROPERTY_PROXIES = 83;
    private static final int METHOD_TYPE_PRIMARY = 101;
    private static final int METHOD_TYPE_SECONDARY = 102;
    private int nextMethodIndex;

    public PascalBackend(ContainerNode container, BufferWriter bufferWriter, String rootFile, Vector topLevelInclFiles) {
        super(((Node)((Object)container))._repository, bufferWriter, rootFile, topLevelInclFiles);
        ((PRepositoryNode)((Node)((Object)container))._repository).pascalInit(rootFile);
        this.generate(container);
    }

    public PascalBackend(ContainerNode container, BufferWriter bufferWriter, String rootFile, Vector topLevelInclFiles, String fileName) {
        super(((Node)((Object)container))._repository, bufferWriter, rootFile, topLevelInclFiles);
        ((PRepositoryNode)container).pascalInit(fileName);
        this.generate(container);
    }

    protected final void add(char c) {
        super.add(this._pass, c);
    }

    protected final void add(int i) {
        super.add(this._pass, i);
    }

    protected final void add(String s) {
        super.add(this._pass, s);
    }

    protected final void addln(int i) {
        super.addln(this._pass, i);
    }

    protected final void addln(long l) {
        super.addln(this._pass, l);
    }

    protected final void addln(String s) {
        super.addln(this._pass, s);
    }

    private void assembleImplementation(PExceptionNode def) {
        this.usePascalUnitImplementationBuffer(this._pass, def);
        switch (this._pass) {
            case 0: {
                break;
            }
            case 1: {
                if (this.getPascalExceptionPropertiesBuffer(this._pass, def).length() > 0) {
                    this.printUnindented(this.getPascalExceptionPropertiesBuffer(this._pass, def).toString());
                }
                if (this.getPascalExceptionPropertyMethodsBuffer(this._pass, def).length() > 0) {
                    this.printUnindented(this.getPascalExceptionPropertyMethodsBuffer(this._pass, def).toString());
                }
                if (this.getPascalExceptionMethodsBuffer(this._pass, def).length() <= 0) break;
                this.printUnindented(this.getPascalExceptionMethodsBuffer(this._pass, def).toString());
                break;
            }
            case 2: {
                break;
            }
        }
        def.componentBuffers.discard(this._pass);
    }

    private void assembleImplementation(PInterfaceNode def) {
        this.usePascalUnitImplementationBuffer(this._pass, def);
        switch (this._pass) {
            case 0: {
                if (this.getPascalInterfacePropertyMethodsBuffer(this._pass, def).length() > 0) {
                    this.writeIdlComment("Implementation of Accessor and mutator methods for Properties (IDL Attributes).");
                    this.printUnindented(this.getPascalInterfacePropertyMethodsBuffer(this._pass, def).toString());
                }
                if (this.getPascalInterfaceMethodsBuffer(this._pass, def).length() <= 0) break;
                this.writeIdlComment("Implementation of Interface methods representing IDL operations.");
                this.printUnindented(this.getPascalInterfaceMethodsBuffer(this._pass, def).toString());
                break;
            }
            case 1: {
                if (this.getPascalInterfacePropertyMethodsBuffer(this._pass, def).length() > 0) {
                    this.writeIdlComment("Implementation of Accessor and mutator methods for Properties (IDL Attributes).");
                    this.printUnindented(this.getPascalInterfacePropertyMethodsBuffer(this._pass, def).toString());
                }
                if (this.getPascalInterfaceMethodsBuffer(this._pass, def).length() <= 0) break;
                this.writeIdlComment("Implementation of Interface methods representing IDL operations.");
                this.printUnindented(this.getPascalInterfaceMethodsBuffer(this._pass, def).toString());
                break;
            }
            case 2: {
                if (this.getPascalInterfacePropertyMethodsBuffer(this._pass, def).length() > 0) {
                    this.writeIdlComment("Implementation of Accessor and mutator methods for Properties (IDL Attributes).");
                    this.printUnindented(this.getPascalInterfacePropertyMethodsBuffer(this._pass, def).toString());
                    this.newLine();
                }
                if (this.getPascalInterfaceMethodsBuffer(this._pass, def).length() <= 0) break;
                this.writeIdlComment("Implementation of Interface methods representing IDL operations.");
                this.printUnindented(this.getPascalInterfaceMethodsBuffer(this._pass, def).toString());
                break;
            }
            case 3: {
                if (this.getPascalInterfacePropertyMethodsBuffer(this._pass, def).length() > 0) {
                    this.writeIdlComment("Implementation of Accessor and mutator methods for Properties (IDL Attributes).");
                    this.printUnindented(this.getPascalInterfacePropertyMethodsBuffer(this._pass, def).toString());
                    this.newLine();
                }
                if (this.getPascalInterfaceMethodsBuffer(this._pass, def).length() <= 0) break;
                this.writeIdlComment("Implementation of Interface methods representing IDL operations.");
                this.printUnindented(this.getPascalInterfaceMethodsBuffer(this._pass, def).toString());
            }
        }
        def.componentBuffers.discard(this._pass);
    }

    private void assemblePascalCFile(Node def) {
        String fullFileName = null;
        switch (def._kind) {
            case 6: {
                fullFileName = String.valueOf(((PModuleNode)def).pascalCFilePath).concat(String.valueOf(((PModuleNode)def).pascalCUnitName));
                break;
            }
            case 17: {
                fullFileName = String.valueOf(((PRepositoryNode)def).pascalCFilePath).concat(String.valueOf(((PRepositoryNode)def).pascalCUnitName));
                break;
            }
            default: {
                fullFileName = null;
                this._ER.internalError(String.valueOf(new StringBuffer("invalid Node kind ").append(def._kind).append(" passed to assemblePascalCFile(Node, String)")));
            }
        }
        this.assemblePascalFile(def, 1, PascalBeOptions.overwriteStubs, fullFileName, "", "", "", "Warning : This section should contain no type definitions. There may have been an error in the operation of the idl2pas compiler.", "", "Warning : This section should contain no constants. There may have been an error in the operation of the idl2pas compiler.", "", "Warning : This section should contain no enumerated datatypes. There may have been an error in the operation of the idl2pas compiler.", "", "", "", "", "", "", "", "", "", "", "", "", "");
        switch (def._kind) {
            case 6: {
                ((PModuleNode)def).componentBuffers.discard(this._pass);
                break;
            }
            case 17: {
                ((PRepositoryNode)def).componentBuffers.discard(this._pass);
                break;
            }
            default: {
                fullFileName = null;
                this._ER.internalError(String.valueOf(new StringBuffer("invalid Node kind ").append(def._kind).append(" passed to assemblePascalCFile(Node, String)")));
            }
        }
    }

    private final void assemblePascalFile(Node def, int pass, boolean overwrite, String name, String UsesCaveat, String emptyUsesComment, String usesComment, String emptyTypedefComment, String typedefComment, String emptyConstComment, String constComment, String emptyEnumComment, String enumComment, String emptyInterfaceFwdDefComment, String interfaceFwdDefComment, String emptyInterfaceDefComment, String interfaceDefComment, String emptyImplementationVarComment, String implementationVarComment, String emptyImplementationComment, String implementationComment, String emptyInitialisationComment, String initialisationComment, String emptyFinalisationComment, String finalisationComment) {
        boolean bConstSectionIsEmpty;
        boolean bTypeSectionIsEmpty = this.getPascalUnitInterfaceFwdDefBuffer(pass, def).toString().length() <= 0 && this.getPascalUnitTypedefBuffer(pass, def).toString().length() <= 0 && this.getPascalUnitInterfaceDescriptionBuffer(pass, def).toString().length() <= 0;
        boolean bEnumSectionIsEmpty = this.getPascalUnitEnumsBuffer(pass, def).toString().length() <= 0;
        boolean bl = bConstSectionIsEmpty = this.getPascalUnitConstantsBuffer(pass, def).toString().length() <= 0;
        if (bTypeSectionIsEmpty && bEnumSectionIsEmpty && bConstSectionIsEmpty && !PascalBeOptions.generateEmptyUnits) {
            return;
        }
        this.useFile(name);
        this.printDirect(this.getPascalUnitPreambleBuffer(pass, def).toString());
        this.printDirect(GenericBackend.LINE_SEP);
        this.printDirect(GenericBackend.LINE_SEP);
        this.printDirect("interface");
        this.printDirect(GenericBackend.LINE_SEP);
        if (!(bConstSectionIsEmpty && bEnumSectionIsEmpty && bTypeSectionIsEmpty)) {
            this.printSubsectionToFile("uses", this.getPascalUnitUnitsUsedBuffer(pass, def).toString(), emptyUsesComment, usesComment);
        }
        if (!bEnumSectionIsEmpty) {
            this.printSubsectionToFile("type", this.getPascalUnitEnumsBuffer(pass, def).toString(), emptyEnumComment, enumComment);
        }
        if (!bConstSectionIsEmpty) {
            this.printSubsectionToFile("const", this.getPascalUnitConstantsBuffer(pass, def).toString(), emptyConstComment, constComment);
        }
        if (!bTypeSectionIsEmpty) {
            this.printDirect(GenericBackend.LINE_SEP);
            this.printDirect("type");
            this.printDirect(GenericBackend.LINE_SEP);
            this.printSubsectionToFile("", this.getPascalUnitInterfaceFwdDefBuffer(pass, def).toString(), emptyInterfaceFwdDefComment, interfaceFwdDefComment);
            this.printSubsectionToFile("", this.getPascalUnitTypedefBuffer(pass, def).toString(), emptyTypedefComment, typedefComment);
            this.printSubsectionToFile("", this.getPascalUnitInterfaceDescriptionBuffer(pass, def).toString(), emptyInterfaceDefComment, interfaceDefComment);
        }
        this.printDirect(GenericBackend.LINE_SEP);
        this.printDirect(GenericBackend.LINE_SEP);
        this.printDirect("implementation");
        this.printDirect(GenericBackend.LINE_SEP);
        if (this.getPascalUnitUnitsUsed2Buffer(pass, def).toString().length() > 0 && this.getPascalUnitUnitsUsed2Buffer(pass, def).toString().trim().length() > 0) {
            this.printSubsectionToFile("uses", this.getPascalUnitUnitsUsed2Buffer(pass, def).toString(), emptyUsesComment, usesComment);
        }
        this.printSectionToFile("var", this.getPascalUnitImplementationVarBuffer(pass, def).toString(), emptyImplementationVarComment, implementationVarComment);
        this.printSectionToFile("", this.getPascalUnitImplementationBuffer(pass, def).toString(), emptyImplementationComment, implementationComment);
        this.printDirect(GenericBackend.LINE_SEP);
        this.printDirect(GenericBackend.LINE_SEP);
        this.printDirect("initialization");
        this.printDirect(GenericBackend.LINE_SEP);
        this.printSectionToFile("", this.getPascalUnitInitialisationManagerBuffer(pass, def).toString(), emptyInitialisationComment, initialisationComment);
        this.printSectionToFile("", this.getPascalUnitInitialisationExceptionBuffer(pass, def).toString(), "", "");
        this.printSectionToFile("finalization", this.getPascalUnitFinalisationBuffer(pass, def).toString(), emptyFinalisationComment, finalisationComment);
        this.printDirect(GenericBackend.LINE_SEP);
        this.printDirect(GenericBackend.LINE_SEP);
        this.printDirect("end.");
        this.closeFile(name, overwrite);
    }

    private void assemblePascalIFile(Node def) {
        String fullFileName = null;
        switch (def._kind) {
            case 6: {
                fullFileName = String.valueOf(((PModuleNode)def).pascalIFilePath).concat(String.valueOf(((PModuleNode)def).pascalIUnitName));
                break;
            }
            case 17: {
                fullFileName = String.valueOf(((PRepositoryNode)def).pascalIFilePath).concat(String.valueOf(((PRepositoryNode)def).pascalIUnitName));
                break;
            }
            default: {
                fullFileName = null;
                this._ER.internalError(String.valueOf(new StringBuffer("invalid Node kind ").append(def._kind).append(" passed to assemblePascalIFile(Node, String)")));
            }
        }
        this.assemblePascalFile(def, 0, PascalBeOptions.overwriteInterfaces, fullFileName, "", "", "", "", "", "(Do not edit the values assigned to these constants.)", "", "", "", "", "", "", "", "Warning : There should be no implementation variables in this unit. There may have been an error in the operation of the idl2pas compiler.", "", "Warning : There should be no implementation code in this unit. There may have been an error in the operation of the idl2pas compiler.", "", "Warning : There should be no initialization code in this unit. There may have been an error in the operation of the idl2pas compiler.", "", "Warning : There should be no finalization code in this unit. There may have been an error in the operation of the idl2pas compiler.", "");
        switch (def._kind) {
            case 6: {
                ((PModuleNode)def).componentBuffers.discard(this._pass);
                break;
            }
            case 17: {
                ((PRepositoryNode)def).componentBuffers.discard(this._pass);
                break;
            }
            default: {
                fullFileName = null;
                this._ER.internalError(String.valueOf(new StringBuffer("invalid Node kind ").append(def._kind).append(" passed to assemblePascalIFile(Node, String)")));
            }
        }
    }

    private void assemblePascalPFile(Node def) {
        String fullFileName = null;
        switch (def._kind) {
            case 6: {
                fullFileName = String.valueOf(((PModuleNode)def).pascalSFilePath).concat(String.valueOf(((PModuleNode)def).pascalPUnitName));
                break;
            }
            case 17: {
                fullFileName = String.valueOf(((PRepositoryNode)def).pascalSFilePath).concat(String.valueOf(((PRepositoryNode)def).pascalPUnitName));
                break;
            }
            default: {
                fullFileName = null;
                this._ER.internalError(String.valueOf(new StringBuffer("invalid Node kind ").append(def._kind).append(" passed to assemblePascalPFile(Node, String)")));
            }
        }
        this.assemblePascalFile(def, 3, PascalBeOptions.overwriteImplementations, fullFileName, "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "");
        switch (def._kind) {
            case 6: {
                ((PModuleNode)def).componentBuffers.discard(this._pass);
                break;
            }
            case 17: {
                ((PRepositoryNode)def).componentBuffers.discard(this._pass);
                break;
            }
            default: {
                fullFileName = null;
                this._ER.internalError(String.valueOf(new StringBuffer("invalid Node kind ").append(def._kind).append(" passed to assemblePascalPFile(Node, String)")));
            }
        }
    }

    private void assemblePascalSFile(Node def) {
        String fullFileName = null;
        switch (def._kind) {
            case 6: {
                fullFileName = String.valueOf(((PModuleNode)def).pascalSFilePath).concat(String.valueOf(((PModuleNode)def).pascalSUnitName));
                break;
            }
            case 17: {
                fullFileName = String.valueOf(((PRepositoryNode)def).pascalSFilePath).concat(String.valueOf(((PRepositoryNode)def).pascalSUnitName));
                break;
            }
            default: {
                fullFileName = null;
                this._ER.internalError(String.valueOf(new StringBuffer("invalid Node kind ").append(def._kind).append(" passed to assemblePascalSFile(Node, String)")));
            }
        }
        this.assemblePascalFile(def, 2, PascalBeOptions.overwriteSkeletons, fullFileName, "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "");
        switch (def._kind) {
            case 6: {
                ((PModuleNode)def).componentBuffers.discard(this._pass);
                break;
            }
            case 17: {
                ((PRepositoryNode)def).componentBuffers.discard(this._pass);
                break;
            }
            default: {
                fullFileName = null;
                this._ER.internalError(String.valueOf(new StringBuffer("invalid Node kind ").append(def._kind).append(" passed to assemblePascalSFile(Node, String)")));
            }
        }
    }

    private void assembleSignature(PExceptionNode def) {
        this.usePascalUnitInterfaceDescriptionBuffer(this._pass, def);
        switch (this._pass) {
            case 0: {
                break;
            }
            case 1: {
                if (this.getPascalExceptionFieldsBuffer(this._pass, def).length() > 0) {
                    this.println("private");
                    this.printUnindented(this.getPascalExceptionFieldsBuffer(this._pass, def).toString());
                }
                if (this.getPascalExceptionPropertyMethodsBuffer(this._pass, def).length() > 0) {
                    this.println("protected");
                    this.printUnindented(this.getPascalExceptionPropertyMethodsBuffer(this._pass, def).toString());
                }
                if (this.getPascalExceptionPropertiesBuffer(this._pass, def).length() <= 0 && this.getPascalExceptionMethodsBuffer(this._pass, def).length() <= 0) break;
                this.println("public");
                if (this.getPascalExceptionPropertiesBuffer(this._pass, def).length() > 0) {
                    this.printUnindented(this.getPascalExceptionPropertiesBuffer(this._pass, def).toString());
                }
                if (this.getPascalExceptionMethodsBuffer(this._pass, def).length() <= 0) break;
                this.printUnindented(this.getPascalExceptionMethodsBuffer(this._pass, def).toString());
                break;
            }
            case 2: {
                break;
            }
        }
        def.componentBuffers.discard(this._pass);
    }

    private void assembleSignature(PInterfaceNode def) {
        this.usePascalUnitInterfaceDescriptionBuffer(this._pass, def);
        switch (this._pass) {
            case 0: {
                if (this.getPascalInterfacePropertyMethodsBuffer(this._pass, def).length() > 0) {
                    this.writeIdlComment("Accessor and mutator methods for Properties (IDL Attributes).");
                    this.printUnindented(this.getPascalInterfacePropertyMethodsBuffer(this._pass, def).toString());
                }
                if (this.getPascalInterfaceMethodsBuffer(this._pass, def).length() > 0) {
                    this.writeIdlComment("Interface methods representing IDL operations.");
                    this.printUnindented(this.getPascalInterfaceMethodsBuffer(this._pass, def).toString());
                }
                if (this.getPascalInterfacePropertiesBuffer(this._pass, def).length() <= 0) break;
                this.writeIdlComment("Properties representing IDL Attributes.");
                this.printUnindented(this.getPascalInterfacePropertiesBuffer(this._pass, def).toString());
                break;
            }
            case 1: {
                if (this.getPascalInterfacePropertyMethodsBuffer(this._pass, def).length() > 0) {
                    this.println("protected");
                    this.printUnindented(this.getPascalInterfacePropertyMethodsBuffer(this._pass, def).toString());
                }
                if (this.getPascalInterfaceMethodsBuffer(this._pass, def).length() > 0) {
                    this.println("public");
                    this.printUnindented(this.getPascalInterfaceMethodsBuffer(this._pass, def).toString());
                }
                if (this.getPascalInterfacePropertiesBuffer(this._pass, def).length() <= 0) break;
                this.println("published");
                this.printUnindented(this.getPascalInterfacePropertiesBuffer(this._pass, def).toString());
                break;
            }
            case 2: {
                if (this.getPascalInterfacePropertiesBuffer(this._pass, def).length() > 0) {
                    this.println("private");
                    this.printUnindented(this.getPascalInterfacePropertiesBuffer(this._pass, def).toString());
                }
                if (this.getPascalInterfaceMethodsBuffer(this._pass, def).length() > 0) {
                    this.println("public");
                    this.printUnindented(this.getPascalInterfaceMethodsBuffer(this._pass, def).toString());
                }
                if (this.getPascalInterfacePropertyMethodsBuffer(this._pass, def).length() <= 0) break;
                this.println("published");
                this.printUnindented(this.getPascalInterfacePropertyMethodsBuffer(this._pass, def).toString());
                break;
            }
            case 3: {
                if (this.getPascalInterfacePropertyMethodsBuffer(this._pass, def).length() > 0) {
                    this.printUnindented(this.getPascalInterfacePropertyMethodsBuffer(this._pass, def).toString());
                }
                if (this.getPascalInterfaceMethodsBuffer(this._pass, def).length() > 0) {
                    this.println("public");
                    this.printUnindented(this.getPascalInterfaceMethodsBuffer(this._pass, def).toString());
                }
                if (this.getPascalInterfacePropertiesBuffer(this._pass, def).length() <= 0) break;
                this.printUnindented(this.getPascalInterfacePropertiesBuffer(this._pass, def).toString());
            }
        }
        def.componentBuffers.discard(this._pass);
    }

    private void assembleSignature(PStructNode def) {
        this.usePascalUnitInterfaceDescriptionBuffer(this._pass, def);
        switch (this._pass) {
            case 0: {
                if (this.getPascalAdtPropertyMethodsBuffer(this._pass, def).length() > 0) {
                    this.writeIdlComment("Accessor and mutator methods for IDL Structure Elements.");
                    this.printUnindented(this.getPascalAdtPropertyMethodsBuffer(this._pass, def).toString());
                }
                if (this.getPascalAdtPropertiesBuffer(this._pass, def).length() <= 0) break;
                this.writeIdlComment("Properties representing IDL Structure Elements.");
                this.printUnindented(this.getPascalAdtPropertiesBuffer(this._pass, def).toString());
                break;
            }
            case 1: {
                if (this.getPascalAdtPropertyMethodsBuffer(this._pass, def).length() > 0) {
                    this.println("private");
                    this.printUnindented(this.getPascalAdtPropertiesBuffer(this._pass, def).toString());
                }
                if (this.getPascalAdtPropertiesBuffer(this._pass, def).length() <= 0) break;
                this.println("public");
                this.printUnindented(this.getPascalAdtPropertyMethodsBuffer(this._pass, def).toString());
                break;
            }
            case 2: {
                break;
            }
        }
        def.componentBuffers.discard(this._pass);
    }

    private void assembleSignature(PUnionNode def) {
        this.usePascalUnitInterfaceDescriptionBuffer(this._pass, def);
        switch (this._pass) {
            case 0: {
                if (this.getPascalAdtPropertyMethodsBuffer(this._pass, def).length() > 0) {
                    this.writeIdlComment("Accessor and mutator methods for IDL Union Elements.");
                    this.printUnindented(this.getPascalAdtPropertyMethodsBuffer(this._pass, def).toString());
                }
                if (this.getPascalAdtPropertiesBuffer(this._pass, def).length() <= 0) break;
                this.writeIdlComment("Properties representing IDL Union Elements.");
                this.printUnindented(this.getPascalAdtPropertiesBuffer(this._pass, def).toString());
                break;
            }
            case 1: {
                if (this.getPascalAdtPropertyMethodsBuffer(this._pass, def).length() > 0) {
                    this.println("private");
                    this.printUnindented(this.getPascalAdtPropertiesBuffer(this._pass, def).toString());
                }
                if (this.getPascalAdtPropertiesBuffer(this._pass, def).length() <= 0) break;
                this.println("public");
                this.printUnindented(this.getPascalAdtPropertyMethodsBuffer(this._pass, def).toString());
                break;
            }
            case 2: {
                break;
            }
        }
        def.componentBuffers.discard(this._pass);
    }

    private void beginDefaultModule(RepositoryNode rep) {
        PRepositoryNode pRep = (PRepositoryNode)rep;
        if (!pRep.bUnitIsEmpty && pRep.pascalUnstarted[this._pass]) {
            pRep.componentBuffers.reset(this._pass);
            pRep.pascalUnstarted[this._pass] = false;
        }
    }

    protected final void beginLineBreaking() {
        super.beginLineBreaking(this._pass);
    }

    protected void beginModule(ModuleNode module) {
        super.beginModule(module);
        PModuleNode pDef = (PModuleNode)module;
        switch (this._pass) {
            case 0: {
                pDef.componentBuffers.reset(0);
                pDef.pascalUnstarted[0] = false;
                break;
            }
            case 1: {
                pDef.componentBuffers.reset(1);
                pDef.pascalUnstarted[1] = false;
            }
        }
        if (pDef.pascalUnstarted[2]) {
            pDef.componentBuffers.reset(2);
            pDef.pascalUnstarted[2] = false;
        }
        if (pDef.pascalUnstarted[3]) {
            pDef.componentBuffers.reset(3);
            pDef.pascalUnstarted[3] = false;
        }
    }

    private final void calcMethodGuid(PMethod def, MessageDigest guidMD, int mode) {
        switch (mode) {
            case 12: {
                guidMD.update((byte)46);
                guidMD.update(def.pascalName.getBytes());
                guidMD.update((byte)46);
                for (int iMethodCount = 0; iMethodCount < def.pascalParamNames.length; ++iMethodCount) {
                    if (def.pascalParamHelperNames[iMethodCount] != null) {
                        guidMD.update(def.pascalParamHelperNames[iMethodCount].getBytes());
                    } else {
                        guidMD.update(def.pascalParamTypeNames[iMethodCount].getBytes());
                    }
                    guidMD.update((byte)46);
                }
                if (def.hasReturnValue) {
                    guidMD.update(this.writeReturnText(def, mode).getBytes());
                    break;
                }
                String temp = "void";
                guidMD.update(temp.getBytes());
                break;
            }
            default: {
                this._ER.internalError(String.valueOf(new StringBuffer("invalid mode ").append(mode).append(" passed to calcMethodGuid (PMethod, MessageDigest, int)")));
            }
        }
    }

    private final void calcMethodGuids(ContainedNode[] methods, MessageDigest guidMD, int mode) {
        int len = methods.length;
        block4: for (int i = 0; i < len; ++i) {
            switch (methods[i]._kind) {
                case 7: {
                    this.calcMethodGuid(((POperationNode)methods[i]).pascalMethod, guidMD, mode);
                    continue block4;
                }
                case 2: {
                    PAttributeNode attribute = (PAttributeNode)methods[i];
                    this.calcMethodGuid(attribute.pascalGetMethod, guidMD, mode);
                    if (attribute._readOnly) continue block4;
                    this.calcMethodGuid(attribute.pascalSetMethod, guidMD, mode);
                    continue block4;
                }
                default: {
                    this._ER.internalError(String.valueOf(new StringBuffer("invalid kind ").append(methods[i]._kind).append(" passed to calcMethodGuids(ContainedNode[], MessageDigest, int)")));
                }
            }
        }
    }

    protected void endDefaultModule(RepositoryNode repository) {
        PRepositoryNode pRep = (PRepositoryNode)repository;
        if (!pRep.bUnitIsEmpty) {
            switch (this._pass) {
                case 0: {
                    this.writeUsedUnits(0, pRep);
                    this.writeUsedUnits2(0, pRep);
                    this.startPascalIFile(pRep);
                    this.assemblePascalIFile(pRep);
                    pRep.pascalUnwritten[0] = false;
                    break;
                }
                case 1: {
                    this.writeUsedUnits(1, pRep);
                    this.writeUsedUnits2(1, pRep);
                    this.startPascalCFile(pRep);
                    this.assemblePascalCFile(pRep);
                    pRep.pascalUnwritten[1] = false;
                    break;
                }
                case 2: {
                    this.writeUsedUnits(2, pRep);
                    this.writeUsedUnits2(2, pRep);
                    this.startPascalSFile(pRep);
                    this.assemblePascalSFile(pRep);
                    pRep.pascalUnwritten[2] = false;
                    break;
                }
                case 3: {
                    this.writeUsedUnits(3, pRep);
                    this.writeUsedUnits2(3, pRep);
                    this.startPascalPFile(pRep);
                    this.assemblePascalPFile(pRep);
                    pRep.pascalUnwritten[3] = false;
                }
            }
        }
    }

    protected final void endLineBreaking() {
        super.endLineBreaking(this._pass);
    }

    protected void endModule(ModuleNode module) {
        super.endModule(module);
        PModuleNode pMod = (PModuleNode)module;
        switch (this._pass) {
            case 0: {
                this.writeUsedUnits(0, pMod);
                this.writeUsedUnits2(0, pMod);
                this.startPascalIFile(pMod);
                this.assemblePascalIFile(pMod);
                pMod.pascalUnwritten[0] = false;
                break;
            }
            case 1: {
                this.writeUsedUnits(1, pMod);
                this.writeUsedUnits2(1, pMod);
                this.startPascalCFile(pMod);
                this.assemblePascalCFile(pMod);
                pMod.pascalUnwritten[1] = false;
                break;
            }
            case 2: {
                this.writeUsedUnits(2, pMod);
                this.writeUsedUnits2(2, pMod);
                this.startPascalSFile(pMod);
                this.assemblePascalSFile(pMod);
                pMod.pascalUnwritten[2] = false;
                break;
            }
            case 3: {
                this.writeUsedUnits(3, pMod);
                this.writeUsedUnits2(3, pMod);
                this.startPascalPFile(pMod);
                this.assemblePascalPFile(pMod);
                pMod.pascalUnwritten[3] = false;
            }
        }
    }

    protected final void ensureIndent() {
        super.ensureIndent(this._pass);
    }

    protected final void ensureNewLine() {
        super.ensureNewLine(this._pass);
    }

    private final String formatGuid(MessageDigest guidMD) {
        byte[] MD5digest = guidMD.digest();
        StringBuffer Guid = new StringBuffer(2 * MD5digest.length + 4);
        for (int i = 0; i < MD5digest.length; ++i) {
            int k = MD5digest[i] & 0xFF;
            int len = Guid.length();
            if (len == 8 || len == 13 || len == 18 || len == 23) {
                Guid.append('-');
            }
            if (k < 16) {
                Guid.append("0".concat(String.valueOf(Integer.toHexString(k))));
                continue;
            }
            Guid.append(Integer.toHexString(k));
        }
        return Guid.toString().toUpperCase();
    }

    protected final void gen() {
        if (this._depSolver == this._topDepSolver) {
            if (PascalBeOptions.generateInterfaces) {
                this._pass = 0;
                this.beginDefaultModule(this._repository);
                super.gen();
                this.endDefaultModule(this._repository);
            }
            if (PascalBeOptions.generateStubs) {
                this._pass = 1;
                this.beginDefaultModule(this._repository);
                super.gen();
                this.endDefaultModule(this._repository);
            }
            if (PascalBeOptions.generateSkeletons) {
                this._pass = 2;
                this.beginDefaultModule(this._repository);
                super.gen();
                this.endDefaultModule(this._repository);
            }
            if (PascalBeOptions.generateImplementations) {
                this._pass = 3;
                this.beginDefaultModule(this._repository);
                super.gen();
                this.endDefaultModule(this._repository);
            }
        } else {
            super.gen();
        }
    }

    protected final void genAlias(AliasNode def) {
        PAliasNode pdef = (PAliasNode)def;
        if (pdef.pascalUnwritten[this._pass]) {
            switch (this._pass) {
                case 0: {
                    this.pascalIfaceSignature(pdef);
                    break;
                }
                case 1: {
                    this.pascalHelperSignature(pdef);
                    this.pascalHelperImplementation(pdef);
                    break;
                }
                case 2: {
                    break;
                }
            }
            pdef.pascalUnwritten[this._pass] = false;
        }
    }

    protected final void genConstant(ConstantNode def) {
        PConstantNode pdef = (PConstantNode)def;
        if (pdef.pascalUnwritten[this._pass]) {
            switch (this._pass) {
                case 0: {
                    this.pascalIfaceSignature(pdef);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
            }
            pdef.pascalUnwritten[this._pass] = false;
        }
    }

    protected void genEnum(EnumNode def, String declarator) {
        PEnumNode pdef = (PEnumNode)def;
        if (pdef.pascalUnwritten[this._pass]) {
            switch (this._pass) {
                case 0: {
                    this.pascalIfaceSignature(pdef);
                    break;
                }
                case 1: {
                    this.pascalHelperSignature(pdef);
                    this.pascalHelperImplementation(pdef);
                    break;
                }
                case 2: {
                    break;
                }
            }
            pdef.pascalUnwritten[this._pass] = false;
        }
    }

    protected final void genException(ExceptionNode def) {
        PExceptionNode pdef = (PExceptionNode)def;
        if (pdef.pascalUnwritten[this._pass]) {
            switch (this._pass) {
                case 0: {
                    break;
                }
                case 1: {
                    this.pascalStubSignature(pdef);
                    this.pascalStubImplementation(pdef);
                    this.pascalStubInitialization(pdef);
                    this.pascalStubFinalization(pdef);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    this._ER.internalError(String.valueOf(new StringBuffer("invalid mode ").append(this._pass).append(" passed to genException (final PExceptionNode, int)")));
                }
            }
            pdef.pascalUnwritten[this._pass] = false;
            this.genContents(def);
        }
    }

    protected final void genInterface(InterfaceNode def) {
        PInterfaceNode pdef = (PInterfaceNode)def;
        if (pdef.pascalUnwritten[this._pass]) {
            switch (this._pass) {
                case 0: {
                    this.pascalIfaceSignature(pdef);
                    break;
                }
                case 1: {
                    this.pascalHelperSignature(pdef);
                    this.pascalStubSignature(pdef);
                    this.pascalHelperImplementation(pdef);
                    this.pascalStubImplementation(pdef);
                    this.pascalHelperInitialization(pdef);
                    break;
                }
                case 2: {
                    this.pascalSkeletonSignature(pdef);
                    this.pascalSkeletonImplementation(pdef);
                    break;
                }
                case 3: {
                    this.pascalImplSignature(pdef);
                    this.pascalImplImplementation(pdef);
                }
            }
            pdef.pascalUnwritten[this._pass] = false;
            this.genContents(def);
        }
    }

    protected final void genStruct(StructNode def, String dec) {
        PStructNode pdef = (PStructNode)def;
        if (pdef.pascalUnwritten[this._pass]) {
            int len = pdef.pascalMembersAreAnonymousAliases.length;
            for (int i = 0; i < len; ++i) {
                if (!pdef.pascalMembersAreAnonymousAliases[i]) continue;
                this.genAlias((AliasNode)((Object)pdef.pascalMemberTypes[i]));
            }
            switch (this._pass) {
                case 0: {
                    this.pascalIfaceSignature(pdef);
                    break;
                }
                case 1: {
                    this.pascalHelperSignature(pdef);
                    this.pascalStubSignature(pdef);
                    this.pascalHelperImplementation(pdef);
                    this.pascalStubImplementation(pdef);
                    break;
                }
                case 2: {
                    break;
                }
            }
            pdef.pascalUnwritten[this._pass] = false;
            this.genContents(def);
        }
    }

    protected final void genUnion(UnionNode def, String dec) {
        PUnionNode pdef = (PUnionNode)def;
        if (pdef.pascalUnwritten[this._pass]) {
            int len = pdef.pascalMembersAreAnonymousAliases.length;
            for (int i = 0; i < len; ++i) {
                if (!pdef.pascalMembersAreAnonymousAliases[i]) continue;
                this.genAlias((AliasNode)((Object)pdef.pascalMemberTypes[i]));
            }
            switch (this._pass) {
                case 0: {
                    this.pascalIfaceSignature(pdef);
                    break;
                }
                case 1: {
                    this.pascalHelperSignature(pdef);
                    this.pascalStubSignature(pdef);
                    this.pascalHelperImplementation(pdef);
                    this.pascalStubImplementation(pdef);
                    break;
                }
                case 2: {
                    break;
                }
            }
            pdef.pascalUnwritten[this._pass] = false;
            this.genContents(def);
        }
    }

    public void generate(ContainerNode container) {
        super.generate(container);
    }

    protected final int horizPos() {
        return super.horizPos(this._pass);
    }

    protected final void indent() {
        super.indent(this._pass);
    }

    protected final void indent(int i) {
        super.indent(this._pass, i);
    }

    protected final void indentTo(int i) {
        super.indentTo(this._pass, i);
    }

    private boolean needsRangeCheck(Type type) {
        return type.kind() == 13 && ((PrimitiveNode)type)._pkind == 17;
    }

    protected final void newLine() {
        super.newLine(this._pass);
    }

    private String padCommentToLength(String stringToPad) {
        return String.valueOf(new StringBuffer("{").append(this.padToLength(stringToPad)).append("}"));
    }

    private String padCommentToLength(String title, String datum) {
        int padLength = 77 - title.length() - datum.length() - this.getCurrentIndent(this._pass).length();
        String paddedComment = null;
        paddedComment = padLength < 0 ? String.valueOf(new StringBuffer(String.valueOf(this.padCommentToLength(title))).append("\n").append(this.getCurrentIndent(this._pass)).append(this.padCommentToLength("  ".concat(String.valueOf(datum))))) : this.padCommentToLength(String.valueOf(title).concat(String.valueOf(datum)));
        return paddedComment;
    }

    private String padToLength(String stringToPad) {
        return this.padToLength(stringToPad, 77);
    }

    private String padToLength(String stringToPad, int overallLength) {
        String paddedString = null;
        if (stringToPad.length() >= overallLength) {
            paddedString = stringToPad;
        } else {
            StringBuffer temp = new StringBuffer(overallLength);
            temp.append(stringToPad);
            int padLength = overallLength - stringToPad.length() - this.getCurrentIndent(this._pass).length() + 1;
            if (padLength < 0) {
                padLength = 0;
            }
            for (int count = 1; count < padLength; ++count) {
                temp.append(' ');
            }
            paddedString = temp.toString();
        }
        return paddedString;
    }

    private final void pascalHelperFwdDef(ContainedNode def, String className) {
        this.usePascalUnitInterfaceFwdDefBuffer(this._pass, def);
        this.indent(1);
        this.println(String.valueOf(className).concat(" = class;"));
        this.indent(-1);
    }

    private final void pascalHelperFwdDef(PInterfaceNode def) {
        this.usePascalUnitInterfaceFwdDefBuffer(this._pass, def);
        this.indent(1);
        this.println(String.valueOf(def.pascalHelperName).concat(" = class;"));
        this.indent(-1);
    }

    private final void pascalHelperImplementation(PAliasNode def) {
        switch (def._type.kind()) {
            case 16: {
                this.pascalHelperImplementation(def, (PArrayNode)def.pascalType);
                break;
            }
            case 15: {
                this.pascalHelperImplementation(def, (PSequenceNode)def.pascalType);
                break;
            }
            default: {
                this.pascalHelperImplementation(def, def.pascalType);
            }
        }
    }

    private final void pascalHelperImplementation(PAliasNode def, PArrayNode pArray) {
        int i1;
        this.usePascalUnitImplementationBuffer(this._pass, def);
        this.writeIdlSectionComment(def, "Implementation of Pascal helper class : ", def.pascalHelperFullName, "supporting Pascal interface           : ", def.pascalFullName);
        this.newLine();
        this.println(String.valueOf(new StringBuffer("class procedure ").append(def.pascalHelperName).append(".Insert(var _A: CORBA.Any; const _Value : ").append(def.pascalFullName).append(");")));
        this.println("var");
        this.indent(1);
        this.println("_Output : CORBA.OutputStream;");
        this.indent(-1);
        this.println("begin");
        this.indent(1);
        this.println("_Output := ORB.CreateOutputStream;");
        this.println(String.valueOf(def.pascalHelperName).concat(".Write(_Output, _Value);"));
        this.println(String.valueOf(new StringBuffer("ORB.PutAny(_A, ").append(def.pascalHelperName).append(".TypeCode, _Output);")));
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(new StringBuffer("class function  ").append(def.pascalHelperName).append(".Extract(const _A : CORBA.Any): ").append(def.pascalFullName).append(";")));
        this.println("var");
        this.indent(1);
        this.println("_Input : CORBA.InputStream;");
        this.indent(-1);
        this.println("begin");
        this.indent(1);
        this.println("Orb.GetAny(_A, _Input);");
        this.println(String.valueOf(new StringBuffer("Result := ").append(def.pascalHelperName).append(".Read(_Input);")));
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(new StringBuffer("class function  ").append(def.pascalHelperName).append(".TypeCode: CORBA.TypeCode;")));
        this.println("begin");
        this.indent(1);
        this.print(String.valueOf(new StringBuffer("Result := ORB.CreateArrayTC(").append(pArray._length).append(", ")));
        if (pArray.getTkHelperFullName() != null) {
            this.add(String.valueOf(pArray.getTkHelperFullName()).concat(".TypeCode()"));
        } else {
            this.add(String.valueOf(new StringBuffer("ORB.CreateTC(Integer(").append(pArray.getTkName()).append("))")));
        }
        this.addln(");");
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(new StringBuffer("class function  ").append(def.pascalHelperName).append(".RepositoryId: string;")));
        this.println("begin");
        this.indent(1);
        this.println(String.valueOf(new StringBuffer("Result := '").append(def._repId).append("';")));
        this.indent(-1);
        this.println("end;");
        PAliasNode pAlias = def;
        StringBuffer temp = new StringBuffer();
        int len2 = pAlias.pascalDimensions.length;
        for (int j = 0; j < len2; ++j) {
            temp.append(String.valueOf(new StringBuffer("[I").append(j).append("]")));
        }
        String Indexes = temp.toString();
        StringBuffer temp2 = new StringBuffer();
        int len = pAlias.pascalDimensions.length;
        for (int i0 = 0; i0 < len; ++i0) {
            if (i0 > 0) {
                temp2.append(", ");
            }
            temp2.append("I".concat(String.valueOf(i0)));
        }
        String Cardinals = temp2.toString();
        this.newLine();
        this.println(String.valueOf(new StringBuffer("class function  ").append(def.pascalHelperName).append(".Read(const _Input: CORBA.InputStream) : ").append(def.pascalFullName).append(";")));
        this.println("var");
        this.indent(1);
        this.println(String.valueOf(Cardinals).concat(" : Cardinal;"));
        this.indent(-1);
        this.println("begin");
        int len3 = pAlias.pascalDimensions.length;
        for (i1 = 0; i1 < len3; ++i1) {
            this.indent(1);
            this.println(String.valueOf(new StringBuffer("for I").append(i1).append(" := 0 to ").append(pAlias.pascalDimensions[i1] - 1).append(" do")));
            this.println("begin");
        }
        this.indent(1);
        if (pArray.getHelperFullName() != null) {
            this.println(String.valueOf(new StringBuffer("Result").append(Indexes).append(" := ").append(pArray.getHelperFullName()).append(".Read(_Input);")));
        } else {
            this.println(String.valueOf(new StringBuffer("_Input.Read").append(pArray.getReadWritePrefix()).append("(Result").append(Indexes).append(");")));
        }
        this.writeReadRangeCheck(pArray.pascalType, "Result".concat(String.valueOf(Indexes)), def.pascalFullName);
        this.indent(-1);
        len3 = pAlias.pascalDimensions.length;
        for (i1 = 0; i1 < len3; ++i1) {
            this.println("end;");
            this.indent(-1);
        }
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(new StringBuffer("class procedure ").append(def.pascalHelperName).append(".Write(const _Output: CORBA.OutputStream; const _Value: ").append(def.pascalFullName).append(");")));
        this.println("var");
        this.indent(1);
        this.println(String.valueOf(Cardinals).concat(" : Cardinal;"));
        this.indent(-1);
        this.println("begin");
        len3 = pAlias.pascalDimensions.length;
        for (i1 = 0; i1 < len3; ++i1) {
            this.indent(1);
            this.println(String.valueOf(new StringBuffer("for I").append(i1).append(" := 0 to ").append(pAlias.pascalDimensions[i1] - 1).append(" do")));
            this.println("begin");
        }
        this.indent(1);
        this.writeWriteRangeCheck(pArray.pascalType, "_Value".concat(String.valueOf(Indexes)), def.pascalFullName);
        if (pArray.getHelperFullName() != null) {
            this.println(String.valueOf(new StringBuffer(String.valueOf(pArray.getHelperFullName())).append(".Write(_Output, _Value").append(Indexes).append(");")));
        } else {
            this.println(String.valueOf(new StringBuffer("_Output.Write").append(pArray.getReadWritePrefix()).append("(_Value").append(Indexes).append(");")));
        }
        this.indent(-1);
        len3 = pAlias.pascalDimensions.length;
        for (i1 = 0; i1 < len3; ++i1) {
            this.println("end;");
            this.indent(-1);
        }
        this.println("end;");
    }

    private final void pascalHelperImplementation(PAliasNode def, PSequenceNode pSequence) {
        String SubIndexes;
        StringBuffer temp4;
        int i1;
        this.usePascalUnitImplementationBuffer(this._pass, def);
        this.writeIdlSectionComment(def, "Implementation of Pascal helper class : ", def.pascalHelperFullName, "supporting Pascal interface           : ", def.pascalFullName);
        this.newLine();
        this.println(String.valueOf(new StringBuffer("class procedure ").append(def.pascalHelperName).append(".Insert(var _A : CORBA.Any; const _Value : ").append(def.pascalFullName).append(");")));
        this.println("var");
        this.indent(1);
        this.println("_Output : CORBA.OutputStream;");
        this.indent(-1);
        this.println("begin");
        this.indent(1);
        this.println("_Output := ORB.CreateOutputStream;");
        this.println(String.valueOf(def.pascalHelperName).concat(".Write(_Output, _Value);"));
        this.println(String.valueOf(new StringBuffer("ORB.PutAny(_A, ").append(def.pascalHelperName).append(".TypeCode, _Output);")));
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(new StringBuffer("class function ").append(def.pascalHelperName).append(".Extract(const _A : CORBA.Any): ").append(def.pascalFullName).append(";")));
        this.println("var");
        this.indent(1);
        this.println("_Input : InputStream;");
        this.indent(-1);
        this.println("begin");
        this.indent(1);
        this.println("Orb.GetAny(_A, _Input);");
        this.println(String.valueOf(new StringBuffer("Result := ").append(def.pascalHelperName).append(".Read(_Input);")));
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(new StringBuffer("class function  ").append(def.pascalHelperName).append(".TypeCode: CORBA.TypeCode;")));
        this.println("begin");
        this.indent(1);
        this.print(String.valueOf(new StringBuffer("Result := ORB.CreateSequenceTC(").append(pSequence._bound).append(", ")));
        if (pSequence.getTkHelperFullName() != null) {
            this.add(String.valueOf(pSequence.getTkHelperFullName()).concat(".TypeCode()"));
        } else {
            this.add(String.valueOf(new StringBuffer("ORB.CreateTC(Integer(").append(pSequence.getTkName()).append("))")));
        }
        this.addln(");");
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(new StringBuffer("class function  ").append(def.pascalHelperName).append(".RepositoryId: string;")));
        this.println("begin");
        this.indent(1);
        this.println(String.valueOf(new StringBuffer("Result := '").append(def._repId).append("';")));
        this.indent(-1);
        this.println("end;");
        PAliasNode pAlias = def;
        StringBuffer temp = new StringBuffer();
        int len2 = pAlias.pascalDimensions.length;
        for (int j = 0; j < len2; ++j) {
            temp.append(String.valueOf(new StringBuffer("[I").append(j).append("]")));
        }
        String Indexes = temp.toString();
        StringBuffer temp2 = new StringBuffer();
        StringBuffer temp3 = new StringBuffer();
        int len = pAlias.pascalDimensions.length;
        for (int i0 = 0; i0 < len; ++i0) {
            if (i0 > 0) {
                temp2.append(", ");
                temp3.append(", ");
            }
            temp2.append("I".concat(String.valueOf(i0)));
            temp3.append("L".concat(String.valueOf(i0)));
        }
        String CardinalsI = temp2.toString();
        String CardinalsL = temp3.toString();
        this.newLine();
        this.println(String.valueOf(new StringBuffer("class function  ").append(def.pascalHelperName).append(".Read(const _Input : CORBA.InputStream) : ").append(def.pascalFullName).append(";")));
        this.println("var");
        this.indent(1);
        this.println(String.valueOf(CardinalsL).concat(" : Cardinal;"));
        this.println(String.valueOf(CardinalsI).concat(" : Cardinal;"));
        this.indent(-1);
        this.println("begin");
        int len3 = pAlias.pascalDimensions.length;
        for (i1 = 0; i1 < len3; ++i1) {
            this.indent(1);
            temp4 = new StringBuffer();
            for (int j4 = 0; j4 < i1; ++j4) {
                temp4.append(String.valueOf(new StringBuffer("[I").append(j4).append("]")));
            }
            SubIndexes = temp4.toString();
            this.println(String.valueOf(new StringBuffer("_Input.ReadULong(L").append(i1).append(");")));
            if (pAlias.pascalDimensions[i1] != 0) {
                this.println(String.valueOf(new StringBuffer("if (L").append(i1).append(" > ").append(pAlias.pascalDimensions[i1]).append(") then raise MARSHAL.Create(0, COMPLETED_YES);")));
            } else {
                this.println(String.valueOf(new StringBuffer("SetLength(Result").append(SubIndexes).append(", L").append(i1).append(");")));
            }
            this.println(String.valueOf(new StringBuffer("if (L").append(i1).append(" > ").append("0) then")));
            this.println("begin");
            this.indent(1);
            this.println(String.valueOf(new StringBuffer("for I").append(i1).append(" := 0 to High(Result").append(SubIndexes).append(") do")));
            this.println("begin");
        }
        this.indent(1);
        if (pSequence.getHelperFullName() != null) {
            this.println(String.valueOf(new StringBuffer("Result").append(Indexes).append(" := ").append(pSequence.getHelperFullName()).append(".Read(_Input);")));
        } else {
            this.println(String.valueOf(new StringBuffer("_Input.Read").append(pSequence.getReadWritePrefix()).append("(Result").append(Indexes).append(");")));
        }
        this.writeReadRangeCheck(pSequence.pascalType, String.valueOf(new StringBuffer("Result").append(Indexes).append("")), def.pascalFullName);
        this.indent(-1);
        len3 = pAlias.pascalDimensions.length;
        for (i1 = 0; i1 < len3; ++i1) {
            this.println("end;");
            this.indent(-1);
            this.println("end;");
            this.indent(-1);
        }
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(new StringBuffer("class procedure ").append(def.pascalHelperName).append(".Write(const _Output: CORBA.OutputStream; const _Value: ").append(def.pascalFullName).append(");")));
        this.println("var");
        this.indent(1);
        this.println(String.valueOf(CardinalsL).concat(" : Cardinal;"));
        this.println(String.valueOf(CardinalsI).concat(" : Cardinal;"));
        this.indent(-1);
        this.println("begin");
        len3 = pAlias.pascalDimensions.length;
        for (i1 = 0; i1 < len3; ++i1) {
            this.indent(1);
            temp4 = new StringBuffer();
            for (int j4 = 0; j4 < i1; ++j4) {
                temp4.append(String.valueOf(new StringBuffer("[I").append(j4).append("]")));
            }
            SubIndexes = temp4.toString();
            this.println(String.valueOf(new StringBuffer("L").append(i1).append(" := Length(_Value").append(SubIndexes).append(");")));
            if (pAlias.pascalDimensions[i1] != 0) {
                this.println(String.valueOf(new StringBuffer("if (L").append(i1).append(" > ").append(pAlias.pascalDimensions[i1]).append(") then raise MARSHAL.Create(0, COMPLETED_NO);")));
            }
            this.println(String.valueOf(new StringBuffer("_Output.WriteULong(L").append(i1).append(");")));
            this.println(String.valueOf(new StringBuffer("if (L").append(i1).append(" > ").append("0) then")));
            this.println("begin");
            this.indent(1);
            this.println(String.valueOf(new StringBuffer("for I").append(i1).append(" := 0 to High(_Value").append(SubIndexes).append(") do")));
            this.println("begin");
        }
        this.indent(1);
        this.writeWriteRangeCheck(pSequence.pascalType, "_Value".concat(String.valueOf(Indexes)), def.pascalFullName);
        if (pSequence.getHelperFullName() != null) {
            this.println(String.valueOf(new StringBuffer(String.valueOf(pSequence.getHelperFullName())).append(".Write(_Output, _Value").append(Indexes).append(");")));
        } else {
            this.println(String.valueOf(new StringBuffer("_Output.Write").append(pSequence.getReadWritePrefix()).append("(_Value").append(Indexes).append(");")));
        }
        this.indent(-1);
        len3 = pAlias.pascalDimensions.length;
        for (i1 = 0; i1 < len3; ++i1) {
            this.println("end;");
            this.indent(-1);
            this.println("end;");
            this.indent(-1);
        }
        this.println("end;");
    }

    private void pascalHelperImplementation(PAliasNode def, PType aliasType) {
        this.usePascalUnitImplementationBuffer(this._pass, def);
        this.writeIdlSectionComment(def, "Implementation of Pascal helper class : ", def.pascalHelperFullName, "supporting Pascal interface           : ", def.pascalFullName);
        this.newLine();
        this.println(String.valueOf(new StringBuffer("class procedure ").append(def.pascalHelperName).append(".Insert(var _A : CORBA.Any; const _Value : ").append(def.pascalFullName).append(");")));
        this.println("begin");
        this.indent(1);
        this.println("_A := _Value;");
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(new StringBuffer("class function ").append(def.pascalHelperName).append(".Extract(const _A : CORBA.Any) : ").append(def.pascalFullName).append(";")));
        if (aliasType.kind() == 13) {
            if (((PPrimitiveNode)aliasType)._pkind == 9) {
                this.println("var");
                this.indent(1);
                this.println("_s : String;");
                this.indent(-1);
                this.println("begin");
                this.indent(1);
                this.println("_s := _A;");
                this.println(String.valueOf(new StringBuffer("Result := ").append(def.pascalFullName).append("(_s[1]);")));
                this.indent(-1);
                this.println("end;");
            } else {
                this.println("var");
                this.indent(1);
                this.println("_Input : InputStream;");
                this.println(String.valueOf(new StringBuffer("_Temp  : ").append(aliasType.getTypeFullName()).append(";")));
                this.indent(-1);
                this.println("begin");
                this.indent(1);
                this.println("Orb.GetAny(_A, _Input);");
                this.println(String.valueOf(new StringBuffer("_Input.Read").append(aliasType.getReadWritePrefix()).append("(_Temp);")));
                this.println(String.valueOf(new StringBuffer("Result := ").append(def.pascalFullName).append("(_Temp);")));
                this.indent(-1);
                this.println("end;");
            }
        } else {
            this.println("begin");
            this.indent(1);
            this.println(String.valueOf(new StringBuffer("Result := ").append(aliasType.getHelperFullName()).append(".Extract(_A);")));
            this.indent(-1);
            this.println("end;");
        }
        this.newLine();
        this.println(String.valueOf(new StringBuffer("class function  ").append(def.pascalHelperName).append(".TypeCode : CORBA.TypeCode;")));
        this.println("begin");
        this.indent(1);
        this.println(String.valueOf(new StringBuffer("Result := ORB.CreateAliasTC(RepositoryId, '").append(def.pascalName).append("', ORB.CreateTC(Integer(0)));")));
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(new StringBuffer("class function  ").append(def.pascalHelperName).append(".RepositoryId : string;")));
        this.println("begin");
        this.indent(1);
        this.println(String.valueOf(new StringBuffer("Result := '").append(def._repId).append("';")));
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(new StringBuffer("class function  ").append(def.pascalHelperName).append(".Read(const _Input: CORBA.InputStream) : ").append(def.pascalFullName).append(";")));
        this.println("begin");
        this.indent(1);
        if (aliasType.getHelperFullName() != null) {
            this.println(String.valueOf(new StringBuffer("Result := ").append(aliasType.getHelperFullName()).append(".Read(_Input);")));
        } else {
            this.println(String.valueOf(new StringBuffer("_Input.Read").append(aliasType.getReadWritePrefix()).append("(Result);")));
        }
        this.writeReadRangeCheck(aliasType, "Result", def.pascalFullName);
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(new StringBuffer("class procedure ").append(def.pascalHelperName).append(".Write(const _Output : CORBA.OutputStream; const _Value :").append(def.pascalFullName).append(");")));
        this.println("begin");
        this.indent(1);
        this.writeWriteRangeCheck(aliasType, "_Value", def.pascalFullName);
        if (aliasType.getHelperFullName() != null) {
            this.println(String.valueOf(aliasType.getHelperFullName()).concat(".Write(_Output, _Value);"));
        } else {
            this.println(String.valueOf(new StringBuffer("_Output.Write").append(aliasType.getReadWritePrefix()).append("(_Value);")));
        }
        this.indent(-1);
        this.println("end;");
    }

    private final void pascalHelperImplementation(PEnumNode def) {
        this.usePascalUnitImplementationBuffer(this._pass, def);
        this.writeIdlSectionComment(def, "Implementation of Pascal helper class : ", def.pascalHelperFullName, "supporting Pascal interface           : ", def.pascalFullName);
        this.newLine();
        this.println(String.valueOf(new StringBuffer("class procedure ").append(def.pascalHelperName).append(".Insert(var _A : CORBA.Any; const _Value : ").append(def.pascalFullName).append(");")));
        this.println("begin");
        this.indent(1);
        this.println("_A := _Value;");
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(new StringBuffer("class function ").append(def.pascalHelperName).append(".Extract(const _A : CORBA.Any) : ").append(def.pascalFullName).append(";")));
        this.println("begin");
        this.indent(1);
        this.println(String.valueOf(new StringBuffer("Result := ").append(def.pascalFullName).append("(_A);")));
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(new StringBuffer("class function ").append(def.pascalHelperName).append(".TypeCode : CORBA.TypeCode;")));
        this.println("begin");
        this.indent(1);
        this.print(String.valueOf(new StringBuffer("Result := ORB.CreateEnumTC(RepositoryId, '").append(def.pascalName).append("', [")));
        int len = def._memberNames.size();
        for (int i = 0; i < len; ++i) {
            this.add(String.valueOf(new StringBuffer("'").append(def._memberNames.elementAt(i).toString()).append("'")));
            if (i >= len - 1) continue;
            this.add(", ");
        }
        this.addln("]);");
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(new StringBuffer("class function ").append(def.pascalHelperName).append(".RepositoryId: string;")));
        this.println("begin");
        this.indent(1);
        this.println(String.valueOf(new StringBuffer("Result := '").append(def._repId).append("';")));
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(new StringBuffer("class function ").append(def.pascalHelperName).append(".Read(const _Input : CORBA.InputStream) : ").append(def.pascalFullName).append(";")));
        this.println("var");
        this.indent(1);
        this.println("_Temp: Cardinal;");
        this.indent(-1);
        this.println("begin");
        this.indent(1);
        this.println("_Input.ReadULong(_Temp);");
        this.println(String.valueOf(new StringBuffer("Result := ").append(def.pascalFullName).append("(_Temp);")));
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(new StringBuffer("class procedure ").append(def.pascalHelperName).append(".Write(const _Output : CORBA.OutputStream; const _Value  : ").append(def.pascalFullName).append(");")));
        this.println("begin");
        this.indent(1);
        this.println("_Output.WriteULong(Cardinal(_Value));");
        this.indent(-1);
        this.println("end;");
    }

    private final void pascalHelperImplementation(PInterfaceNode def) {
        this.usePascalUnitImplementationBuffer(this._pass, def);
        this.writeIdlSectionComment(def, "Implementation of Pascal helper class : ", def.pascalHelperFullName, "supporting Pascal interface           : ", def.pascalFullName, "", "");
        this.newLine();
        this.println(String.valueOf(new StringBuffer("class procedure ").append(def.pascalHelperName).append(".Insert(var _A : CORBA.Any; const _Value : ").append(def.pascalFullName).append(");")));
        this.println("begin");
        this.indent(1);
        this.println(String.valueOf(new StringBuffer("_A := Orb.MakeObjectRef( ").append(def.pascalHelperName).append(".TypeCode, _Value as CORBA.CORBAObject);")));
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(new StringBuffer("class function ").append(def.pascalHelperName).append(".Extract(var _A : CORBA.Any): ").append(def.pascalFullName).append(";")));
        this.println("var");
        this.indent(1);
        this.println("_obj : Corba.CorbaObject;");
        this.indent(-1);
        this.println("begin");
        this.indent(1);
        this.println("_obj := Orb.GetObjectRef(_A);");
        this.println(String.valueOf(new StringBuffer("Result := ").append(def.pascalHelperName).append(".Narrow(_obj, True);")));
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(new StringBuffer("class function ").append(def.pascalHelperName).append(".TypeCode : CORBA.TypeCode;")));
        this.println("begin");
        this.indent(1);
        this.println(String.valueOf(new StringBuffer("Result := ORB.CreateInterfaceTC(RepositoryId, '").append(def.pascalName).append("');")));
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(new StringBuffer("class function ").append(def.pascalHelperName).append(".RepositoryId : string;")));
        this.println("begin");
        this.indent(1);
        this.println(String.valueOf(new StringBuffer("Result := '").append(def._repId).append("';")));
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(new StringBuffer("class function ").append(def.pascalHelperName).append(".Read(const _Input : CORBA.InputStream) : ").append(def.pascalFullName).append(";")));
        this.println("var");
        this.indent(1);
        this.println("_Obj : CORBA.CORBAObject;");
        this.indent(-1);
        this.println("begin");
        this.indent(1);
        this.println("_Input.ReadObject(_Obj);");
        this.println("Result := Narrow(_Obj, True)");
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(new StringBuffer("class procedure ").append(def.pascalHelperName).append(".Write(const _Output : CORBA.OutputStream; const _Value : ").append(def.pascalFullName).append(");")));
        this.println("begin");
        this.indent(1);
        this.println("_Output.WriteObject(_Value as CORBA.CORBAObject);");
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(new StringBuffer("class function ").append(def.pascalHelperName).append(".Narrow(const _Obj : CORBA.CORBAObject; _IsA : Boolean) : ").append(def.pascalFullName).append(";")));
        this.println("begin");
        this.indent(1);
        this.println("Result := nil;");
        this.println(String.valueOf(new StringBuffer("if (_Obj = nil) or (_Obj.QueryInterface(").append(def.pascalFullName).append(", Result) = 0) then")));
        this.indent(1);
        this.println("exit;");
        this.indent(-1);
        this.println("if _IsA and _Obj._IsA(RepositoryId) then");
        this.indent(1);
        this.println(String.valueOf(new StringBuffer("Result := ").append(def.pascalStubName).append(".Create(_Obj);")));
        this.indent(-2);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(new StringBuffer("class function ").append(def.pascalHelperName).append(".Bind(const _InstanceName : string = ''; _HostName: string = '') : ").append(def.pascalFullName).append(";")));
        this.println("begin");
        this.indent(1);
        this.println("Result := Narrow(ORB.bind(RepositoryId, _InstanceName, _HostName), True);");
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(new StringBuffer("class function ").append(def.pascalHelperName).append(".Bind(_Options : BindOptions; const _InstanceName : string = ''; _HostName : string = '') : ").append(def.pascalFullName).append(";")));
        this.println("begin");
        this.indent(1);
        this.println("Result := Narrow(ORB.bind(RepositoryId, _Options, _InstanceName, _HostName), True);");
        this.indent(-1);
        this.println("end;");
    }

    private final void pascalHelperImplementation(PStructNode def) {
        int i;
        this.usePascalUnitImplementationBuffer(this._pass, def);
        this.writeIdlSectionComment(def, "Implementation of Pascal helper class : ", def.pascalHelperFullName, "supporting Pascal interface           : ", def.pascalFullName);
        this.newLine();
        this.println(String.valueOf(new StringBuffer("class procedure ").append(def.pascalHelperName).append(".Insert(var _A : CORBA.Any; const _Value : ").append(def.pascalFullName).append(");")));
        this.println("var");
        this.indent(1);
        this.println("_Output : CORBA.OutputStream;");
        this.indent(-1);
        this.println("begin");
        this.indent(1);
        this.println("_Output := ORB.CreateOutputStream;");
        this.println(String.valueOf(def.pascalHelperName).concat(".Write(_Output, _Value);"));
        this.println(String.valueOf(new StringBuffer("ORB.PutAny(_A, ").append(def.pascalHelperName).append(".TypeCode, _Output);")));
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(new StringBuffer("class function ").append(def.pascalHelperName).append(".Extract(const _A : CORBA.Any) : ").append(def.pascalFullName).append(";")));
        this.println("var");
        this.indent(1);
        this.println("_Input : CORBA.InputStream;");
        this.indent(-1);
        this.println("begin");
        this.indent(1);
        this.println("Orb.GetAny(_A, _Input);");
        this.println(String.valueOf(new StringBuffer("Result := ").append(def.pascalHelperName).append(".Read(_Input);")));
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(new StringBuffer("class function ").append(def.pascalHelperName).append(".TypeCode : CORBA.TypeCode;")));
        this.println("var");
        this.indent(1);
        this.println("_Seq: StructMemberSeq;");
        this.indent(-1);
        this.println("begin");
        this.indent(1);
        this.println(String.valueOf(new StringBuffer("SetLength(_Seq, ").append(def.pascalMemberNames.length).append(");")));
        int len = def.pascalMemberNames.length;
        for (i = 0; i < len; ++i) {
            this.println(String.valueOf(new StringBuffer("_Seq[").append(i).append("].Name := '").append(def.pascalMemberNames[i]).append("';")));
            this.print(String.valueOf(new StringBuffer("_Seq[").append(i).append("].TC   := ")));
            if (def.pascalMemberTkHelperFullNames[i] != null) {
                this.add(String.valueOf(def.pascalMemberTkHelperFullNames[i]).concat(".TypeCode"));
            } else {
                this.add(String.valueOf(new StringBuffer("ORB.CreateTC(Integer(").append(def.pascalMemberTkNames[i]).append("))")));
            }
            this.addln(";");
        }
        this.println(String.valueOf(new StringBuffer("Result := ORB.MakeStructureTypecode(RepositoryID, '").append(def.pascalName).append("', _Seq);")));
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(new StringBuffer("class function ").append(def.pascalHelperName).append(".RepositoryId : string;")));
        this.println("begin");
        this.indent(1);
        this.println(String.valueOf(new StringBuffer("Result := '").append(def._repId).append("';")));
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(new StringBuffer("class function ").append(def.pascalHelperName).append(".Read(const _Input : CORBA.InputStream) : ").append(def.pascalFullName).append(";")));
        this.println("var");
        this.indent(1);
        this.println(String.valueOf(new StringBuffer("_Value : ").append(def.pascalStubFullName).append(";")));
        this.indent(-1);
        this.println("begin");
        this.indent(1);
        this.println(String.valueOf(new StringBuffer("_Value := ").append(def.pascalStubFullName).append(".Create;")));
        len = def.pascalMemberNames.length;
        for (i = 0; i < len; ++i) {
            if (def.pascalMemberHelperFullNames[i] != null) {
                this.println(String.valueOf(new StringBuffer("_Value.").append(def.pascalMemberNames[i]).append(" := ").append(def.pascalMemberHelperFullNames[i]).append(".Read(_Input);")));
            } else {
                this.println(String.valueOf(new StringBuffer("_Input.Read").append(def.pascalMemberReadWritePrefixes[i]).append("(_Value.").append(def.pascalMemberNames[i]).append(");")));
            }
            this.writeReadRangeCheck(def.pascalMemberTypes[i], "_Value.".concat(String.valueOf(def.pascalMemberNames[i])), def.pascalFullName);
        }
        this.println("Result := _Value;");
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(new StringBuffer("class procedure ").append(def.pascalHelperName).append(".Write(const _Output : CORBA.OutputStream; const _Value : ").append(def.pascalFullName).append(");")));
        this.println("begin");
        this.indent(1);
        len = def.pascalMemberNames.length;
        for (i = 0; i < len; ++i) {
            this.writeWriteRangeCheck(def.pascalMemberTypes[i], "_Value.".concat(String.valueOf(def.pascalMemberNames[i])), def.pascalFullName);
            if (def.pascalMemberHelperFullNames[i] != null) {
                this.println(String.valueOf(new StringBuffer(String.valueOf(def.pascalMemberHelperFullNames[i])).append(".Write(_Output, _Value.").append(def.pascalMemberNames[i]).append(");")));
                continue;
            }
            this.println(String.valueOf(new StringBuffer("_Output.Write").append(def.pascalMemberReadWritePrefixes[i]).append("(_Value.").append(def.pascalMemberNames[i]).append(");")));
        }
        this.indent(-1);
        this.println("end;");
    }

    private final void pascalHelperImplementation(PUnionNode def) {
        int j;
        int len_j;
        int i;
        this.usePascalUnitImplementationBuffer(this._pass, def);
        this.writeIdlSectionComment(def, "Implementation of Pascal helper class : ", def.pascalHelperFullName, "supporting Pascal interface           : ", def.pascalFullName);
        this.newLine();
        this.println(String.valueOf(new StringBuffer("class procedure ").append(def.pascalHelperName).append(".Insert(var _A : CORBA.Any; const _Value : ").append(def.pascalFullName).append(");")));
        this.println("var");
        this.indent(1);
        this.println("_Output : CORBA.OutputStream;");
        this.indent(-1);
        this.println("begin");
        this.indent(1);
        this.println("_Output := ORB.CreateOutputStream;");
        this.println(String.valueOf(def.pascalHelperName).concat(".Write(_Output, _Value);"));
        this.println(String.valueOf(new StringBuffer("ORB.PutAny(_A, ").append(def.pascalHelperName).append(".TypeCode, _Output);")));
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(new StringBuffer("class function ").append(def.pascalHelperName).append(".Extract(const _A : CORBA.Any) : ").append(def.pascalFullName).append(";")));
        this.println("var");
        this.indent(1);
        this.println("_Input : CORBA.InputStream;");
        this.indent(-1);
        this.println("begin");
        this.indent(1);
        this.println("Orb.GetAny(_A, _Input);");
        this.println(String.valueOf(new StringBuffer("Result := ").append(def.pascalHelperName).append(".Read(_Input);")));
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(new StringBuffer("class function ").append(def.pascalHelperName).append(".TypeCode : CORBA.TypeCode;")));
        this.println("var");
        this.indent(1);
        this.println("Seq: UnionMemberSeq;");
        this.indent(-1);
        this.println("begin");
        this.indent(1);
        this.println(String.valueOf(new StringBuffer("SetLength(Seq, ").append(def.pascalNumMembers).append(");")));
        int k = 0;
        int len_i = def.pascalMemberNames.length;
        for (i = 0; i < len_i; ++i) {
            len_j = def.pascalMemberLabels[i] != null ? def.pascalMemberLabels[i].length : -1;
            for (j = 0; j < len_j; ++j) {
                this.writeTypecodeSequenceElement(def, i, j, k++);
            }
        }
        if (def.pascalDefaultExists) {
            this.writeTypecodeSequenceDefaultElement(def, k++);
        }
        this.print(String.valueOf(new StringBuffer("Result := ORB.CreateUnionTC(RepositoryID, '").append(def.pascalName).append("', ")));
        if (def.pascalDiscHelperName != null) {
            this.add(String.valueOf(def.pascalDiscHelperName).concat(".TypeCode"));
        } else {
            this.add(String.valueOf(new StringBuffer("ORB.CreateTC(Integer(").append(def.pascalDiscTkName).append("))")));
        }
        this.addln(", Seq);");
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(new StringBuffer("class function ").append(def.pascalHelperName).append(".RepositoryId: string;")));
        this.println("begin");
        this.indent(1);
        this.println(String.valueOf(new StringBuffer("Result := '").append(def._repId).append("';")));
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(new StringBuffer("class function ").append(def.pascalHelperName).append(".Read(const _Input: CORBA.InputStream): ").append(def.pascalFullName).append(";")));
        this.println("var");
        this.indent(1);
        this.println(String.valueOf(new StringBuffer("_Value : ").append(def.pascalStubFullName).append(";")));
        if (def.pascalDiscIsEnum) {
            this.println("_Temp  : Integer;");
        }
        this.indent(-1);
        this.println("begin");
        this.indent(1);
        this.println(String.valueOf(new StringBuffer("_Value := ").append(def.pascalStubName).append(".Create;")));
        if (def.pascalDiscIsEnum) {
            this.println("_Input.ReadLong(_Temp);");
            this.println(String.valueOf(new StringBuffer("_Value._discriminator := ").append(def.pascalDiscTypeName).append("(_Temp);")));
        } else {
            this.println(String.valueOf(new StringBuffer("_Input.Read").append(def.pascalDiscReadWritePrefix).append("(_Value._discriminator);")));
        }
        this.writeReadRangeCheck(def._discriminator, "_Value._discriminator", def.pascalFullName);
        this.println("case _Value._discriminator of");
        this.indent(1);
        len_i = def.pascalMemberNames.length;
        for (i = 0; i < len_i; ++i) {
            len_j = def.pascalMemberLabels[i] != null ? def.pascalMemberLabels[i].length : -1;
            for (j = 0; j < len_j; ++j) {
                this.writeReadElement(def, i, j);
            }
        }
        if (def.pascalDefaultExists) {
            this.writeReadElement(def);
        }
        this.indent(-1);
        this.println("end;");
        this.println("Result := _Value;");
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(new StringBuffer("class procedure ").append(def.pascalHelperName).append(".Write(const _Output : CORBA.OutputStream; const _Value : ").append(def.pascalFullName).append(");")));
        if (def.pascalDiscIsEnum) {
            this.println("var");
            this.indent(1);
            this.println("temp  : Integer;");
            this.indent(-1);
        }
        this.println("begin");
        this.indent(1);
        this.writeWriteRangeCheck(def._discriminator, "_Value._discriminator", def.pascalFullName);
        if (def.pascalDiscIsEnum) {
            this.println("temp := Integer(_Value._discriminator);");
            this.println("_Output.WriteLong(temp);");
        } else {
            this.println(String.valueOf(new StringBuffer("_Output.Write").append(def.pascalDiscReadWritePrefix).append("(_Value._discriminator);")));
        }
        this.println("case _Value._discriminator of");
        this.indent(1);
        len_i = def.pascalMemberNames.length;
        for (i = 0; i < len_i; ++i) {
            len_j = def.pascalMemberLabels[i] != null ? def.pascalMemberLabels[i].length : -1;
            for (j = 0; j < len_j; ++j) {
                this.writeWriteElement(def, i, j);
            }
        }
        if (def.pascalDefaultExists) {
            this.writeWriteElement(def);
        }
        this.indent(-1);
        this.println("end;");
        this.indent(-1);
        this.println("end;");
    }

    private final void pascalHelperInitialization(PInterfaceNode def) {
        this.usePascalUnitInitialisationManagerBuffer(this._pass, def);
        this.writeIdlSectionComment(def, "Initialization of the Pascal helper class : ", def.pascalStubFullName);
    }

    private final void pascalHelperSignature(ContainedNode def, String altComment, String pascalHelperName, String pascalFullName) {
        this.pascalHelperFwdDef(def, pascalHelperName);
        this.usePascalUnitInterfaceDescriptionBuffer(this._pass, def);
        this.indent(1);
        this.writeIdlSectionComment(def, altComment);
        this.newLine();
        this.println(String.valueOf(pascalHelperName).concat(" = class"));
        this.indent(1);
        this.println(String.valueOf(new StringBuffer("class procedure Insert (var   _A: CORBA.Any; const _Value : ").append(pascalFullName).append(");")));
        this.println(String.valueOf(new StringBuffer("class function  Extract(const _A: CORBA.Any): ").append(pascalFullName).append(";")));
        this.println("class function  TypeCode    : CORBA.TypeCode;");
        this.println("class function  RepositoryId: string;");
        this.println(String.valueOf(new StringBuffer("class function  Read (const _Input  : CORBA.InputStream) : ").append(pascalFullName).append(";")));
        this.println(String.valueOf(new StringBuffer("class procedure Write(const _Output : CORBA.OutputStream; const _Value : ").append(pascalFullName).append(");")));
        this.indent(-1);
        this.println("end;");
        this.indent(-1);
    }

    private final void pascalHelperSignature(PAliasNode def) {
        this.pascalHelperSignature(def, String.valueOf(new StringBuffer("Signature of Pascal helper class \"").append(def.pascalHelperFullName).append("\"supporting Pascal interface \"").append(def.pascalFullName).append("\".")), def.pascalHelperName, def.pascalFullName);
    }

    private final void pascalHelperSignature(PEnumNode def) {
        this.pascalHelperSignature(def, String.valueOf(new StringBuffer("Signature of Pascal helper class \"").append(def.pascalHelperFullName).append("\"supporting Pascal interface \"").append(def.pascalFullName).append("\".")), def.pascalHelperName, def.pascalFullName);
    }

    private final void pascalHelperSignature(PInterfaceNode def) {
        this.pascalHelperFwdDef(def);
        this.usePascalUnitInterfaceDescriptionBuffer(this._pass, def);
        this.indent(1);
        this.writeIdlSectionComment(def, "Signature of Pascal helper class : ", def.pascalHelperFullName, "supporting Pascal interface      : ", def.pascalFullName);
        this.newLine();
        this.println(String.valueOf(def.pascalHelperName).concat(" = class"));
        this.indent(1);
        this.println(String.valueOf(new StringBuffer("class procedure Insert (var _A: CORBA.Any; const _Value : ").append(def.pascalFullName).append(");")));
        this.println(String.valueOf(new StringBuffer("class function  Extract(var _A: CORBA.Any) : ").append(def.pascalFullName).append(";")));
        this.println("class function  TypeCode     : CORBA.TypeCode;");
        this.println("class function  RepositoryId : string;");
        this.println(String.valueOf(new StringBuffer("class function  Read (const _Input  : CORBA.InputStream) : ").append(def.pascalFullName).append(";")));
        this.println(String.valueOf(new StringBuffer("class procedure Write(const _Output : CORBA.OutputStream; const _Value : ").append(def.pascalFullName).append(");")));
        this.println(String.valueOf(new StringBuffer("class function  Narrow(const _Obj   : CORBA.CORBAObject; _IsA : Boolean = False) : ").append(def.pascalFullName).append(";")));
        this.println(String.valueOf(new StringBuffer("class function  Bind(const _InstanceName : string = ''; _HostName : string = '') : ").append(def.pascalFullName).append("; overload;")));
        this.println(String.valueOf(new StringBuffer("class function  Bind(_Options : BindOptions; const _InstanceName : string = ''; _HostName: string = '') : ").append(def.pascalFullName).append("; overload;")));
        this.indent(-1);
        this.println("end;");
        this.indent(-1);
    }

    private final void pascalHelperSignature(PStructNode def) {
        this.pascalHelperSignature(def, String.valueOf(new StringBuffer("Signature of Pascal helper class \"").append(def.pascalHelperFullName).append("\"supporting Pascal interface \"").append(def.pascalFullName).append("\".")), def.pascalHelperName, def.pascalFullName);
    }

    private final void pascalHelperSignature(PUnionNode def) {
        this.pascalHelperSignature(def, String.valueOf(new StringBuffer("Signature of Pascal helper class \"").append(def.pascalHelperFullName).append("\"supporting Pascal interface \"").append(def.pascalFullName).append("\".")), def.pascalHelperName, def.pascalFullName);
    }

    private final void pascalIfaceFwdDef(PInterfaceNode def) {
        this.usePascalUnitInterfaceFwdDefBuffer(this._pass, def);
        this.indent(1);
        this.println(String.valueOf(def.pascalName).concat(" = interface;"));
        this.indent(-1);
    }

    private final void pascalIfaceFwdDef(PStructNode def) {
        this.usePascalUnitInterfaceFwdDefBuffer(this._pass, def);
        this.indent(1);
        this.println(String.valueOf(def.pascalName).concat(" = interface;"));
        this.indent(-1);
    }

    private final void pascalIfaceFwdDef(PUnionNode def) {
        this.usePascalUnitInterfaceFwdDefBuffer(this._pass, def);
        this.indent(1);
        this.println(String.valueOf(def.pascalName).concat(" = interface;"));
        this.indent(-1);
    }

    private final void pascalIfaceSignature(PAliasNode def) {
        this.usePascalUnitTypedefBuffer(this._pass, def);
        this.indent(1);
        switch (def._type.kind()) {
            case 16: {
                this.newLine();
                this.writeIdlSectionComment(def, "Pascal array           : ", def.pascalFullName, "derived from IDL array : ", def._name);
                if (def.isAnonymous) {
                    this.writeIdlSectionComment(def, "(This is a generated alias for an anonymous array.)");
                }
                PArrayNode pDef = (PArrayNode)def.pascalType;
                this.print(String.valueOf(def.pascalName).concat(" = array"));
                int pos1 = this.horizPos();
                int len = def.pascalDimensions.length;
                for (int i = 0; i < len; ++i) {
                    if (i > 0) {
                        this.add(" of array ");
                    }
                    this.add(String.valueOf(new StringBuffer("[0..").append(def.pascalDimensions[i] - 1).append("]")));
                }
                this.add(" of ".concat(String.valueOf(def.pascalType.getTypeFullName())));
                this.addln(";");
                break;
            }
            case 15: {
                this.newLine();
                this.writeIdlSectionComment(def, "Pascal array              : ", def.pascalFullName, "derived from IDL sequence : ", def._name);
                if (def.isAnonymous) {
                    this.writeIdlSectionComment(def, "(This is a generated alias for an anonymous sequence.)");
                }
                PSequenceNode pDef = (PSequenceNode)def.pascalType;
                this.print(String.valueOf(def.pascalName).concat(" = array"));
                int pos1 = this.horizPos();
                int len = def.pascalDimensions.length;
                for (int i = 0; i < len; ++i) {
                    if (i > 0) {
                        this.add(" of array ");
                    }
                    if (def.pascalDimensions[i] == 0) continue;
                    this.add(String.valueOf(new StringBuffer("[0..").append(def.pascalDimensions[i] - 1).append("]")));
                }
                this.add(" of ".concat(String.valueOf(def.pascalType.getTypeFullName())));
                this.addln(";");
                break;
            }
            default: {
                this.newLine();
                this.writeIdlSectionComment(def, "Pascal alias           : ", def.pascalFullName, "derived from IDL alias : ", def._name);
                this.println(String.valueOf(new StringBuffer(String.valueOf(def.pascalName)).append(" = ").append(def.pascalType.getTypeFullName()).append(";")));
            }
        }
        this.indent(-1);
    }

    private final void pascalIfaceSignature(PConstantNode def) {
        this.usePascalUnitConstantsBuffer(this._pass, def);
        this.indent(1);
        this.writeIdlSectionComment(def, "Pascal constant           : ", def.pascalFullName, "derived from IDL constant : ", def._name);
        this.newLine();
        this.println(String.valueOf(new StringBuffer(String.valueOf(def.pascalName)).append(" : ").append(def.pascalTypeName).append(" = ").append(def.pascalValue).append(";")));
        this.indent(-1);
    }

    private final void pascalIfaceSignature(PEnumNode def) {
        this.usePascalUnitEnumsBuffer(this._pass, def);
        this.indent(1);
        this.writeIdlSectionComment(def, "Pascal enumeration           : ", def.pascalFullName, "derived from IDL enumeration : ", def._name);
        this.newLine();
        this.print(String.valueOf(def.pascalName).concat(" = ("));
        int len = def.pascalMemberNames.length;
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                this.add(" ");
            }
            this.add(def.pascalMemberNames[i]);
            if (i >= len - 1) continue;
            this.add(",");
        }
        this.println(");");
        this.indent(-1);
    }

    private final void pascalIfaceSignature(PInterfaceNode def) {
        this.pascalIfaceFwdDef(def);
        this.usePascalUnitInterfaceDescriptionBuffer(this._pass, def);
        this.indent(1);
        this.writeIdlSectionComment(def, "Signature of Pascal interface : ", def.pascalFullName, "derived from IDL interface    : ", def._name);
        this.newLine();
        this.print(String.valueOf(def.pascalName).concat(" = interface"));
        this.writeIfaceInheritance(def);
        this.indent(1);
        this.writeGuid(def);
        def.componentBuffers.reset(this._pass);
        this.writeMethods(def, 11);
        this.writeSecondaryMethods(def, 11);
        this.usePascalUnitInterfaceDescriptionBuffer(this._pass, def);
        this.assembleSignature(def);
        this.indent(-1);
        this.println("end;");
        this.indent(-1);
    }

    private final void pascalIfaceSignature(PStructNode def) {
        this.pascalIfaceFwdDef(def);
        this.usePascalUnitInterfaceDescriptionBuffer(this._pass, def);
        this.indent(1);
        this.writeIdlSectionComment(def, "Signature of Pascal interface : ", def.pascalFullName, "derived from IDL structure    : ", def._name);
        this.newLine();
        this.println(String.valueOf(def.pascalName).concat(" = interface"));
        this.indent(1);
        this.writeGuid(def);
        def.componentBuffers.reset(this._pass);
        this.writeMethods(def, 11);
        this.usePascalUnitInterfaceDescriptionBuffer(this._pass, def);
        this.assembleSignature(def);
        this.indent(-1);
        this.println("end;");
        this.indent(-1);
    }

    private final void pascalIfaceSignature(PUnionNode def) {
        this.pascalIfaceFwdDef(def);
        this.usePascalUnitInterfaceDescriptionBuffer(this._pass, def);
        this.indent(1);
        this.writeIdlSectionComment(def, "Signature of Pascal interface : ", def.pascalFullName, "derived from IDL union        : ", def._name);
        this.newLine();
        this.println(String.valueOf(def.pascalName).concat(" = interface"));
        this.indent(1);
        this.writeGuid(def);
        def.componentBuffers.reset(this._pass);
        this.writeMethods(def, 11);
        this.usePascalUnitInterfaceDescriptionBuffer(this._pass, def);
        this.assembleSignature(def);
        this.indent(-1);
        this.println("end;");
        this.indent(-1);
    }

    private void pascalImplImplementation(PInterfaceNode pDef) {
        this.usePascalUnitImplementationBuffer(this._pass, pDef);
        this.writeIdlSectionComment(pDef, "Implementation of Pascal class : ", pDef.pascalImplFullName, "supporting Pascal interface    : ", pDef.pascalFullName);
        this.newLine();
        this.println(String.valueOf(new StringBuffer("constructor ").append(pDef.pascalImplName).append(".Create;")));
        this.println("begin");
        this.indent(1);
        this.println("inherited;");
        this.println("{ *************************** }");
        this.println("{ *** User code goes here *** }");
        this.println("{ *************************** }");
        this.indent(-1);
        this.println("end;");
        pDef.componentBuffers.reset(this._pass);
        this.writeMethods(pDef, 82);
        this.writeSecondaryMethods(pDef, 82);
        this.writeInheritedMethods(pDef, 82);
        this.usePascalUnitImplementationBuffer(this._pass, pDef);
        this.assembleImplementation(pDef);
    }

    private void pascalImplSignature(PInterfaceNode pDef) {
        this.pascalImplSignatureFwdDef(pDef);
        this.usePascalUnitInterfaceDescriptionBuffer(this._pass, pDef);
        this.indent(1);
        this.newLine();
        this.print(String.valueOf(pDef.pascalImplName).concat(" = class"));
        this.writeImplInheritance(pDef);
        this.println("protected");
        this.indent(1);
        this.println("{******************************}");
        this.println("{*** User variables go here ***}");
        this.println("{******************************}");
        this.indent(-1);
        pDef.componentBuffers.reset(this._pass);
        this.writeConstructors(pDef, 0);
        this.writeImplProxyAttributes(pDef, 83);
        this.writeMethods(pDef, 81);
        this.writeSecondaryMethods(pDef, 81);
        this.writeInheritedMethods(pDef, 81);
        this.usePascalUnitInterfaceDescriptionBuffer(this._pass, pDef);
        this.assembleSignature(pDef);
        this.println("end;");
        this.indent(-1);
    }

    private final void pascalImplSignatureFwdDef(PInterfaceNode def) {
        this.usePascalUnitInterfaceFwdDefBuffer(this._pass, def);
        this.indent(1);
        this.println(String.valueOf(def.pascalImplName).concat(" = class;"));
        this.indent(-1);
    }

    private final void pascalSkeletonFwdDef(PInterfaceNode def) {
        this.usePascalUnitInterfaceFwdDefBuffer(this._pass, def);
        this.indent(1);
        this.println(String.valueOf(def.pascalSkeletonName).concat(" = class;"));
        this.indent(-1);
    }

    private void pascalSkeletonImplementation(PInterfaceNode pdef) {
        this.usePascalUnitImplementationBuffer(this._pass, pdef);
        this.writeIdlSectionComment(pdef, "Implementation of Pascal skeleton class : ", pdef.pascalSkeletonFullName, "supporting Pascal interface             : ", pdef.pascalFullName);
        this.newLine();
        this.println(String.valueOf(new StringBuffer("constructor ").append(pdef.pascalSkeletonName).append(".Create(const InstanceName : string; const Impl : ").append(pdef.pascalFullName).append(");")));
        this.println("begin");
        this.indent(1);
        if (pdef.pascalBases.length == 0 || pdef.pascalBases.length == 1) {
            this.println("inherited;");
        }
        this.println(String.valueOf(new StringBuffer("inherited CreateSkeleton(InstanceName, '").append(pdef.pascalName).append("', '").append(pdef._repId).append("');")));
        this.println("FImplementation := Impl;");
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(new StringBuffer("destructor ").append(pdef.pascalSkeletonName).append(".Destroy;")));
        this.println("begin");
        this.indent(1);
        this.println("FImplementation := nil;");
        this.println("inherited;");
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(new StringBuffer("function ").append(pdef.pascalSkeletonName).append(".GetImplementation : ").append(pdef.pascalFullName).append(";")));
        this.println("begin");
        this.indent(1);
        this.println(String.valueOf(new StringBuffer("result := FImplementation as ").append(pdef.pascalFullName).append(";")));
        this.indent(-1);
        this.println("end;");
        pdef.componentBuffers.reset(this._pass);
        this.writeMethods(pdef, 71);
        this.writeInheritedMethods(pdef, 71);
        this.writeSecondaryMethods(pdef, 71);
        this.writeMethods(pdef, 72);
        this.writeInheritedMethods(pdef, 72);
        this.writeSecondaryMethods(pdef, 72);
        this.usePascalUnitImplementationBuffer(this._pass, pdef);
        this.assembleImplementation(pdef);
    }

    private final void pascalSkeletonInitialisation(PInterfaceNode def) {
        this.usePascalUnitInitialisationManagerBuffer(this._pass, def);
        this.writeIdlSectionComment(def, "Initialization of Pascal skeleton class : ", def.pascalSkeletonFullName, "supporting Pascal interface             : ", def.pascalFullName);
        this.println(String.valueOf(new StringBuffer("SkeletonManager.RegisterSkeleton(_ISkeleton, ").append(def.pascalSkeletonName).append(");")));
    }

    private void pascalSkeletonSignature(PInterfaceNode pDef) {
        this.pascalSkeletonFwdDef(pDef);
        this.usePascalUnitInterfaceDescriptionBuffer(this._pass, pDef);
        this.indent(1);
        this.writeIdlSectionComment(pDef, "Signature of Pascal skeleton class : ", pDef.pascalSkeletonFullName, "supporting IDL interface           : ", pDef._name);
        this.newLine();
        this.print(String.valueOf(pDef.pascalSkeletonName).concat(" = class"));
        this.writeSkelInheritance(pDef);
        pDef.componentBuffers.reset(this._pass);
        this.usePascalInterfacePropertiesBuffer(this._pass, pDef);
        this.indent(2);
        this.println(String.valueOf(new StringBuffer("FImplementation : ").append(pDef.pascalName).append(";")));
        this.indent(-2);
        this.writeConstructors(pDef, 0);
        this.writeMethods(pDef, 55);
        this.writeInheritedMethods(pDef, 55);
        this.writeSecondaryMethods(pDef, 55);
        this.writeHookMethods(pDef, 56);
        this.writeInheritedHookMethods(pDef, 56);
        this.writeSecondaryHookMethods(pDef, 56);
        this.usePascalUnitInterfaceDescriptionBuffer(this._pass, pDef);
        this.assembleSignature(pDef);
        this.println("end;");
        this.indent(-1);
    }

    private final void pascalStubFinalization(PExceptionNode def) {
        this.usePascalUnitFinalisationBuffer(this._pass, def);
        this.writeIdlSectionComment(def, "Finalization of the Pascal exception : ", def.pascalFullName);
        this.println(String.valueOf(new StringBuffer("UnRegisterUserException(").append(def.pascalProxyFullName).append(");")));
    }

    private final void pascalStubFwdDef(PExceptionNode def) {
        this.usePascalUnitInterfaceFwdDefBuffer(this._pass, def);
        this.indent(1);
        this.println(String.valueOf(def.pascalStubName).concat(" = class;"));
        this.indent(-1);
    }

    private final void pascalStubFwdDef(PInterfaceNode def) {
        this.usePascalUnitInterfaceFwdDefBuffer(this._pass, def);
        this.indent(1);
        this.println(String.valueOf(def.pascalStubName).concat(" = class;"));
        this.indent(-1);
    }

    private final void pascalStubFwdDef(PStructNode def) {
        this.usePascalUnitInterfaceFwdDefBuffer(this._pass, def);
        this.indent(1);
        this.println(String.valueOf(def.pascalStubName).concat(" = class;"));
        this.indent(-1);
    }

    private final void pascalStubFwdDef(PUnionNode def) {
        this.usePascalUnitInterfaceFwdDefBuffer(this._pass, def);
        this.indent(1);
        this.println(String.valueOf(def.pascalStubName).concat(" = class;"));
        this.indent(-1);
    }

    private final void pascalStubImplementation(PExceptionNode def) {
        this.writeExceptionProxyVar(def);
        this.usePascalUnitImplementationBuffer(this._pass, def);
        this.writeIdlSectionComment(def, "Implementation of Pascal stub class : ", def.pascalStubFullName, "supporting Pascal interface         : ", def.pascalFullName);
        def.componentBuffers.reset(this._pass);
        this.writeMethods(def, 36);
        this.writeConstructors(def, 36);
        this.writeCopyMethods(def, 36);
        this.assembleImplementation(def);
        this.writeFactoryMethod(def);
    }

    private final void pascalStubImplementation(PInterfaceNode def) {
        this.usePascalUnitImplementationBuffer(this._pass, def);
        this.writeIdlSectionComment(def, "Implementation of Pascal stub class : ", def.pascalStubFullName, "supporting Pascal interface         : ", def.pascalFullName);
        def.componentBuffers.reset(this._pass);
        this.writeMethods(def, 33);
        this.writeSecondaryMethods(def, 33);
        this.writeInheritedMethods(def, 33);
        this.usePascalUnitImplementationBuffer(this._pass, def);
        this.assembleImplementation(def);
    }

    private final void pascalStubImplementation(PStructNode def) {
        int i;
        this.usePascalUnitImplementationBuffer(this._pass, def);
        this.writeIdlSectionComment(def, "Implementation of Pascal stub class : ", def.pascalStubFullName, "supporting Pascal interface         : ", def.pascalFullName);
        this.newLine();
        this.println(String.valueOf(new StringBuffer("constructor ").append(def.pascalStubName).append(".Create;")));
        this.println("begin");
        this.indent(1);
        this.println("inherited Create;");
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.print(String.valueOf(new StringBuffer("constructor ").append(def.pascalStubName).append(".Create(")));
        int pos1 = this.horizPos();
        int len = def.pascalMemberNames.length;
        for (i = 0; i < len; ++i) {
            this.add(String.valueOf(new StringBuffer("const ").append(def.pascalMemberNames[i]).append(": ").append(def.pascalMemberTypeNames[i])));
            if (i >= len - 1) continue;
            this.addln(";");
            this.indentTo(pos1);
        }
        this.println(");");
        this.println("begin");
        this.indent(1);
        len = def.pascalMemberNames.length;
        for (i = 0; i < len; ++i) {
            this.println(String.valueOf(new StringBuffer("Self.").append(def.pascalMemberNames[i]).append(" := ").append(def.pascalMemberNames[i]).append(";")));
        }
        this.indent(-1);
        this.println("end;");
        len = def.pascalMemberNames.length;
        for (i = 0; i < len; ++i) {
            this.newLine();
            this.println(String.valueOf(new StringBuffer("function  ").append(def.pascalStubName).append(".").append(def.pascalMembers[i].pascalGetMethod.pascalName).append(": ").append(def.pascalMemberTypeNames[i]).append(";")));
            this.println("begin");
            this.indent(1);
            this.println(String.valueOf(new StringBuffer("Result := ").append(def.pascalMemberNames[i]).append(";")));
            this.writeReadRangeCheck(def.pascalMemberTypes[i], "Result", def.pascalFullName);
            this.indent(-1);
            this.println("end;");
            this.newLine();
            this.println(String.valueOf(new StringBuffer("procedure ").append(def.pascalStubName).append(".").append(def.pascalMembers[i].pascalSetMethod.pascalName).append("(const").append(" _Value : ").append(def.pascalMemberTypeNames[i]).append(");")));
            this.println("begin");
            this.indent(1);
            this.writeWriteRangeCheck(def.pascalMemberTypes[i], "_Value", def.pascalFullName);
            this.println(String.valueOf(def.pascalMemberNames[i]).concat(" := _Value;"));
            this.indent(-1);
            this.println("end;");
        }
    }

    private final void pascalStubImplementation(PUnionNode def) {
        this.usePascalUnitImplementationBuffer(this._pass, def);
        this.writeIdlSectionComment(def, "Implementation of Pascal stub class : ", def.pascalStubFullName, "supporting Pascal interface         : ", def.pascalFullName);
        this.newLine();
        this.println(String.valueOf(new StringBuffer("constructor ").append(def.pascalStubName).append(".Create;")));
        this.println("begin");
        this.indent(1);
        this.println(String.valueOf(new StringBuffer("Self._discriminator := ").append(def.pascalDiscTypeName).append("(").append(def.pascalDiscInitValue).append(");")));
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(new StringBuffer("function  ").append(def.pascalStubName).append("._get_discriminator: ").append(def.pascalDiscTypeName).append(";")));
        this.println("begin");
        this.indent(1);
        this.println("Result := _discriminator;");
        this.writeReadRangeCheck(def._discriminator, "Result", def.pascalFullName);
        this.indent(-1);
        this.println("end;");
        int len = def.pascalMemberNames.length;
        for (int i = 0; i < len; ++i) {
            this.newLine();
            this.println(String.valueOf(new StringBuffer("function  ").append(def.pascalStubName).append(".").append(def.pascalMembers[i].pascalGetMethod.pascalName).append(": ").append(def.pascalMemberTypeNames[i]).append(";")));
            this.println("begin");
            this.indent(1);
            this.print("if ( ");
            int pos1 = this.horizPos();
            int len_j = def.pascalMemberLabels[i] != null ? def.pascalMemberLabels[i].length : -1;
            for (int j = 0; j < len_j; ++j) {
                this.add(String.valueOf(new StringBuffer("( _discriminator <> ").append(def.pascalMemberLabels[i][j]).append(" ) ")));
                if (j >= len_j - 1) continue;
                this.addln(" and");
                this.indentTo(pos1);
            }
            if (def.pascalDefaultExists && def._defaultIndex == i) {
                if (len_j > 0) {
                    this.addln(" and");
                    this.indentTo(pos1);
                }
                this.add(String.valueOf(new StringBuffer("( _discriminator <> ").append(def.pascalDefaultDescValue).append(" ) ")));
            }
            this.newLine();
            this.indentTo(pos1 - 1);
            this.addln(")");
            this.indent(1);
            this.println("then raise BAD_OPERATION.Create(0, COMPLETED_YES);");
            this.indent(-1);
            this.println(String.valueOf(new StringBuffer("Result := ").append(def.pascalMemberNames[i]).append(";")));
            this.writeReadRangeCheck(def.pascalMemberTypes[i], "Result", def.pascalFullName);
            this.indent(-1);
            this.println("end;");
            this.newLine();
            this.println(String.valueOf(new StringBuffer("procedure ").append(def.pascalStubName).append(".").append(def.pascalMembers[i].pascalSetMethod.pascalName).append("(const _Value : ").append(def.pascalMemberTypeNames[i]).append(");")));
            this.println("begin");
            this.indent(1);
            this.print("_discriminator := ");
            this.add(def.pascalMemberLabels[i] != null && def.pascalMemberLabels[i].length > 0 ? def.pascalMemberLabels[i][0] : def.pascalDefaultDescValue);
            this.addln(";");
            this.writeWriteRangeCheck(def.pascalMemberTypes[i], "_Value", def.pascalFullName);
            this.println(String.valueOf(def.pascalMemberNames[i]).concat(" := _Value;"));
            this.indent(-1);
            this.println("end;");
        }
    }

    private final void pascalStubInitialization(PExceptionNode def) {
        this.usePascalUnitInitialisationExceptionBuffer(this._pass, def);
        this.writeIdlSectionComment(def, "Initalization of Pascal stub class : ", def.pascalFullName, "supporting Pascal exception        : ", def.pascalFullName, "IDL exception                      : ", def._name);
        this.println(String.valueOf(new StringBuffer(String.valueOf(def.pascalProxyFullName)).append(" := RegisterUserException('").append(def._name).append("', '").append(def._repId).append("', @").append(def.pascalFactoryFullName).append(");")));
    }

    private final void pascalStubInitialization(PInterfaceNode def) {
        this.usePascalUnitInitialisationManagerBuffer(this._pass, def);
        this.writeIdlSectionComment(def, "Initialization of Pascal stub class : ", def.pascalStubFullName, "supporting Pascal interface         : ", def.pascalFullName);
        this.println(String.valueOf(new StringBuffer("CORBA.StubManager.RegisterStub(").append(def.pascalFullName).append(", ").append(def.pascalStubFullName).append(");")));
    }

    private final void pascalStubSignature(PExceptionNode def) {
        this.pascalStubFwdDef(def);
        this.usePascalUnitInterfaceDescriptionBuffer(this._pass, def);
        this.indent(1);
        this.writeIdlSectionComment(def, "Signature of Pascal stub class : ", def.pascalStubFullName, "supporting IDL exception       : ", def._name);
        this.newLine();
        this.println(String.valueOf(def.pascalStubName).concat(" = class(UserException)"));
        def.componentBuffers.reset(this._pass);
        this.writeMethods(def, 35);
        this.writeConstructors(def, 35);
        this.writeCopyMethods(def, 35);
        this.assembleSignature(def);
        this.println("end;");
        this.indent(-1);
    }

    private final void pascalStubSignature(PInterfaceNode def) {
        this.pascalStubFwdDef(def);
        this.usePascalUnitInterfaceDescriptionBuffer(this._pass, def);
        this.indent(1);
        this.writeIdlSectionComment(def, "Signature of Pascal stub class : ", def.pascalStubFullName, "supporting Pascal interface    : ", def.pascalFullName);
        this.newLine();
        this.print(String.valueOf(def.pascalStubName).concat(" = class"));
        this.writeStubInheritance(def);
        def.componentBuffers.reset(this._pass);
        this.writeMethods(def, 31);
        this.writeSecondaryMethods(def, 31);
        this.writeInheritedMethods(def, 31);
        this.usePascalUnitInterfaceDescriptionBuffer(this._pass, def);
        this.assembleSignature(def);
        this.println("end;");
        this.indent(-1);
    }

    private final void pascalStubSignature(PStructNode def) {
        this.pascalStubFwdDef(def);
        this.usePascalUnitInterfaceDescriptionBuffer(this._pass, def);
        this.indent(1);
        this.writeIdlSectionComment(def, "Signature of Pascal stub class : ", def.pascalStubFullName, "supporting Pascal interface    : ", def.pascalFullName);
        this.newLine();
        this.println(String.valueOf(new StringBuffer(String.valueOf(def.pascalStubName)).append(" = class (TInterfacedObject, ").append(def.pascalFullName).append(")")));
        def.componentBuffers.reset(this._pass);
        this.writeMethods(def, 34);
        this.writeConstructors(def, 34);
        this.usePascalUnitInterfaceDescriptionBuffer(this._pass, def);
        this.assembleSignature(def);
        this.println("end;");
        this.indent(-1);
    }

    private final void pascalStubSignature(PUnionNode def) {
        this.pascalStubFwdDef(def);
        this.usePascalUnitInterfaceDescriptionBuffer(this._pass, def);
        this.indent(1);
        this.writeIdlSectionComment(def, "Signature of Pascal stub class : ", def.pascalStubFullName, "supporting Pascal interface    : ", def.pascalFullName);
        this.newLine();
        this.println(String.valueOf(new StringBuffer(String.valueOf(def.pascalStubName)).append(" = class (TInterfacedObject, ").append(def.pascalFullName).append(")")));
        def.componentBuffers.reset(this._pass);
        this.writeMethods(def, 34);
        this.writeConstructors(def, 34);
        this.usePascalUnitInterfaceDescriptionBuffer(this._pass, def);
        this.assembleSignature(def);
        this.println("end;");
        this.indent(-1);
    }

    protected final void print(String s) {
        super.print(this._pass, s);
    }

    private void printSectionToFile(String _sectionName, String _sectionText, String _infoText, String _emptyText) {
        if (_sectionText.length() != 0 || _emptyText.length() != 0) {
            if (_sectionName != null && _sectionName.length() > 0) {
                this.printDirect(GenericBackend.LINE_SEP);
                this.printDirect(GenericBackend.LINE_SEP);
                this.printDirect(_sectionName);
                this.printDirect(GenericBackend.LINE_SEP);
            }
            this.printToFile(_sectionText, _infoText, _emptyText);
        }
    }

    private void printSubsectionToFile(String _subsectionName, String _subsectionText, String _infoText, String _emptyText) {
        if (_subsectionText.length() != 0 || _emptyText.length() != 0) {
            if (_subsectionName != null && _subsectionName.length() > 0) {
                this.printDirect(GenericBackend.LINE_SEP);
                this.printDirect(_subsectionName);
                this.printDirect(GenericBackend.LINE_SEP);
            }
            this.printToFile(_subsectionText, _infoText, _emptyText);
        }
    }

    private void printToFile(String _sectionText, String _infoText, String _emptyText) {
        if (_sectionText == null || _sectionText.length() == 0) {
            if (_emptyText != null && _emptyText.length() > 0) {
                this.printDirect(String.valueOf(new StringBuffer("  { ").append(_emptyText).append(" }")));
                this.printDirect(GenericBackend.LINE_SEP);
            }
        } else {
            if (_infoText != null && _infoText.length() > 0) {
                this.printDirect(String.valueOf(new StringBuffer("  { ").append(_infoText).append(" }")));
                this.printDirect(GenericBackend.LINE_SEP);
            }
            this.printDirect(_sectionText);
            if (!_sectionText.endsWith(GenericBackend.LINE_SEP)) {
                this.printDirect(GenericBackend.LINE_SEP);
            }
        }
    }

    private final void printUnindented(String s) {
        super.printUnindented(this._pass, s);
    }

    protected final void println(String s) {
        super.println(this._pass, s);
    }

    private final void setUnit(int pass, String unitName) {
        this.println(pass, String.valueOf(new StringBuffer("unit ").append(unitName).append(";")));
    }

    private final void startPascalCFile(PModuleNode def) {
        this.useFile(def.pascalCUnitName);
        this.usePascalUnitPreambleBuffer(1, def);
        this.setUnit(1, def.pascalCUnitName);
        this.writeUserComments(1, def);
        this.writeIdlSectionComment(def, "This unit contains the stub code for IDL module : ", def._name);
    }

    private final void startPascalCFile(PRepositoryNode def) {
        this.useFile(def.pascalCUnitName);
        this.usePascalUnitPreambleBuffer(1, def);
        this.setUnit(1, def.pascalCUnitName);
        this.writeUserComments(1, def);
    }

    private final void startPascalIFile(PModuleNode def) {
        this.useFile(def.pascalIUnitName);
        this.usePascalUnitPreambleBuffer(0, def);
        this.setUnit(0, def.pascalIUnitName);
        this.writeUserComments(0, def);
        this.writeIdlSectionComment(def, "This unit contains the pascal interface code for IDL module : ", def._name);
    }

    private final void startPascalIFile(PRepositoryNode def) {
        this.useFile(def.pascalIUnitName);
        this.usePascalUnitPreambleBuffer(0, def);
        this.setUnit(0, def.pascalIUnitName);
        this.writeUserComments(0, def);
    }

    private final void startPascalPFile(PModuleNode def) {
        this.useFile(def.pascalPUnitName);
        this.usePascalUnitPreambleBuffer(3, def);
        this.setUnit(3, def.pascalPUnitName);
        this.writeUserComments(3, def);
        this.writeIdlSectionComment(def, "This unit contains the implementation code for IDL module : ", def._name);
    }

    private final void startPascalPFile(PRepositoryNode def) {
        this.useFile(def.pascalPUnitName);
        this.usePascalUnitPreambleBuffer(3, def);
        this.setUnit(3, def.pascalPUnitName);
        this.writeUserComments(3, def);
    }

    private final void startPascalSFile(PModuleNode def) {
        this.useFile(def.pascalSUnitName);
        this.usePascalUnitPreambleBuffer(2, def);
        this.setUnit(2, def.pascalSUnitName);
        this.writeUserComments(2, def);
        this.writeIdlSectionComment(def, "This unit contains the skeleton code for IDL module : ", def._name);
    }

    private final void startPascalSFile(PRepositoryNode def) {
        this.useFile(def.pascalSUnitName);
        this.usePascalUnitPreambleBuffer(2, def);
        this.setUnit(2, def.pascalSUnitName);
        this.writeUserComments(2, def);
    }

    protected final void useFile(String baseName) {
        super.useFile(baseName);
    }

    private final void writeComments(int pass, String title1, String datum1, String title2, String datum2, String title3, String datum3) {
        if (this._options.codeHints) {
            if (title1.length() > 0 || datum1.length() > 0) {
                this.println(this.padCommentToLength(title1, datum1));
            }
            if (title2.length() > 0 || datum2.length() > 0) {
                this.println(this.padCommentToLength(title2, datum2));
            }
            if (title3.length() > 0 || datum3.length() > 0) {
                this.println(this.padCommentToLength(title3, datum3));
            }
        }
    }

    private void writeConstructors(PExceptionNode pDef, int mode) {
        switch (mode) {
            case 35: {
                this.usePascalExceptionMethodsBuffer(this._pass, pDef);
                this.indent(2);
                this.println("constructor Create; overload;");
                if (pDef.pascalMemberNames.length > 0) {
                    this.print("constructor Create");
                    if (pDef.pascalMemberNames != null && pDef.pascalMemberNames.length > 0) {
                        this.add("(");
                        int $position0 = this.horizPos();
                        for (int index0 = 0; index0 < pDef.pascalMemberNames.length; ++index0) {
                            this.add(String.valueOf(new StringBuffer("const ").append(pDef.pascalMemberNames[index0]).append(" : ").append(pDef.pascalMemberTypeNames[index0])));
                            if (index0 >= pDef.pascalMemberNames.length - 1) continue;
                            this.add(";");
                            this.newLine();
                            this.indentTo($position0);
                        }
                        this.add(")");
                    }
                    this.addln("; overload;");
                }
                this.indent(-2);
                break;
            }
            case 36: {
                this.usePascalExceptionMethodsBuffer(this._pass, pDef);
                this.newLine();
                this.println(String.valueOf(new StringBuffer("constructor ").append(pDef.pascalName).append(".Create;")));
                this.println("begin");
                this.indent(1);
                this.println("inherited Create;");
                this.indent(-1);
                this.println("end;");
                if (pDef.pascalMemberNames.length <= 0) break;
                this.newLine();
                this.print(String.valueOf(new StringBuffer("constructor ").append(pDef.pascalName).append(".Create")));
                if (pDef.pascalMemberNames != null && pDef.pascalMemberNames.length > 0) {
                    this.add("(");
                    int $position0 = this.horizPos();
                    for (int index0 = 0; index0 < pDef.pascalMemberNames.length; ++index0) {
                        this.add(String.valueOf(new StringBuffer("const ").append(pDef.pascalMemberNames[index0]).append(" : ").append(pDef.pascalMemberTypeNames[index0])));
                        if (index0 >= pDef.pascalMemberNames.length - 1) continue;
                        this.add(";");
                        this.newLine();
                        this.indentTo($position0);
                    }
                    this.add(")");
                }
                this.addln(";");
                this.println("begin");
                this.indent(1);
                this.println("inherited Create;");
                if (pDef.pascalMemberNames != null && pDef.pascalMemberNames.length > 0) {
                    for (int index0 = 0; index0 < pDef.pascalMemberNames.length; ++index0) {
                        this.println(String.valueOf(new StringBuffer(String.valueOf(pDef.pascalFieldNames[index0])).append(" := ").append(pDef.pascalMemberNames[index0]).append(";")));
                    }
                }
                this.indent(-1);
                this.println("end;");
                break;
            }
        }
    }

    private void writeConstructors(PInterfaceNode pDef, int mode) {
        switch (this._pass) {
            case 2: {
                this.usePascalInterfaceMethodsBuffer(this._pass, pDef);
                this.indent(2);
                this.println(String.valueOf(new StringBuffer("constructor Create(const InstanceName: string; const Impl: ").append(pDef.pascalName).append(");")));
                this.println("destructor Destroy; override;");
                this.println(String.valueOf(new StringBuffer("function GetImplementation : ").append(pDef.pascalName).append(";")));
                this.indent(-2);
                break;
            }
            case 3: {
                this.usePascalInterfaceMethodsBuffer(this._pass, pDef);
                this.indent(2);
                this.println("constructor Create;");
                this.indent(-2);
            }
        }
    }

    private void writeConstructors(PStructNode def, int mode) {
        this.usePascalPropertiesBuffer(this._pass, def);
        this.indent(2);
        this.println("constructor Create; overload;");
        this.indent(-2);
        this.usePascalPropertyMethodsBuffer(this._pass, def);
        this.indent(2);
        this.print("constructor Create (");
        int pos1 = this.horizPos();
        for (int i = 0; i < def.pascalMemberNames.length; ++i) {
            this.add(String.valueOf(new StringBuffer("const ").append(def.pascalMemberNames[i]).append(" : ").append(def.pascalMemberTypeNames[i])));
            if (i >= def.pascalMemberNames.length - 1) continue;
            this.addln(";");
            this.print("");
            this.indentTo(pos1);
        }
        this.newLine();
        this.indentTo(pos1 - 1);
        this.addln("); overload;");
        this.indent(-2);
    }

    private void writeConstructors(PUnionNode def, int mode) {
        this.usePascalPropertyMethodsBuffer(this._pass, def);
        this.indent(2);
        this.println("constructor Create;");
        this.indent(-2);
    }

    private void writeCopyMethods(PExceptionNode def, int mode) {
        this.usePascalExceptionMethodsBuffer(this._pass, def);
        switch (mode) {
            case 35: {
                this.indent(2);
                this.println("procedure Copy(const _Input : InputStream); override;");
                this.println("procedure WriteExceptionInfo(var _Output : OutputStream); override;");
                this.indent(-2);
                break;
            }
            case 36: {
                int i;
                this.newLine();
                this.println(String.valueOf(new StringBuffer("procedure ").append(def.pascalName).append(".Copy(const _Input: InputStream);")));
                this.println("begin");
                this.indent(1);
                for (i = 0; i < def.pascalMemberNames.length; ++i) {
                    if (def.pascalMemberHelperFullNames[i] != null) {
                        this.println(String.valueOf(new StringBuffer(String.valueOf(def.pascalFieldNames[i])).append(" := ").append(def.pascalMemberHelperFullNames[i]).append(".Read(_Input);")));
                        continue;
                    }
                    this.println(String.valueOf(new StringBuffer("_Input.Read").append(def.pascalMemberReadWritePrefixes[i]).append("(").append(def.pascalFieldNames[i]).append(");")));
                    this.writeReadRangeCheck(def.pascalMemberTypes[i], def.pascalFieldNames[i], def.pascalFullName);
                }
                this.indent(-1);
                this.println("end;");
                this.newLine();
                this.println(String.valueOf(new StringBuffer("procedure ").append(def.pascalName).append(".WriteExceptionInfo(var _Output : OutputStream);")));
                this.println("begin");
                this.indent(1);
                this.println(String.valueOf(new StringBuffer("_Output.WriteString('").append(def._repId).append("');")));
                for (i = 0; i < def.pascalMemberNames.length; ++i) {
                    if (def.pascalMemberHelperFullNames[i] != null) {
                        this.println(String.valueOf(new StringBuffer(String.valueOf(def.pascalMemberHelperFullNames[i])).append(".Write(_Output, ").append(def.pascalFieldNames[i]).append(");")));
                        continue;
                    }
                    this.writeWriteRangeCheck(def.pascalMemberTypes[i], def.pascalFieldNames[i], def.pascalFullName);
                    this.println(String.valueOf(new StringBuffer("_Output.Write").append(def.pascalMemberReadWritePrefixes[i]).append("(").append(def.pascalFieldNames[i]).append(");")));
                }
                this.indent(-1);
                this.println("end;");
            }
        }
    }

    private final void writeExceptionProxyVar(PExceptionNode def) {
        this.usePascalUnitImplementationVarBuffer(this._pass, def);
        this.indent(1);
        this.writeIdlSectionComment(def, String.valueOf(new StringBuffer("Pascal proxy \"").append(def.pascalProxyFullName).append("\" for the IDL exception ").append(def._name).append(".")));
        this.newLine();
        this.println(String.valueOf(def.pascalProxyName).concat(" : PExceptionDescription;"));
        this.indent(-1);
    }

    private final void writeFactoryMethod(PExceptionNode def) {
        this.usePascalUnitImplementationBuffer(this._pass, def);
        this.println("");
        this.println(String.valueOf(new StringBuffer("function  ").append(def.pascalFactoryName).append(": PExceptionProxy; cdecl;")));
        this.println("begin");
        this.indent(1);
        this.println(String.valueOf(new StringBuffer("with ").append(def.pascalFullName).append(".Create() do Result := Proxy;")));
        this.indent(-1);
        this.println("end;");
    }

    private final void writeFileComments(int pass, String moduleName, String unitIName, String unitCName, String unitSName, String unitPName) {
        String thisUnitName = null;
        switch (pass) {
            case 0: {
                thisUnitName = unitIName;
                break;
            }
            case 1: {
                thisUnitName = unitCName;
                break;
            }
            case 2: {
                thisUnitName = unitSName;
                break;
            }
            case 3: {
                thisUnitName = unitPName;
            }
        }
        this.writeIdlFixedComment(pass, "Delphi Pascal unit      : ".concat(String.valueOf(thisUnitName)));
        this.writeIdlFixedComment(pass, "derived from IDL module : ".concat(String.valueOf(moduleName)));
        this.newLine();
        if (thisUnitName.equals(unitIName)) {
            this.writeIdlComment(pass, "This unit declares the interfaces and variables used by the other generated");
            this.writeIdlComment(pass, "units and must be used with the following generated units;");
        } else if (thisUnitName.equals(unitCName)) {
            this.writeIdlComment(pass, "This unit implements the client-side stub and helper classes and must be used");
            this.writeIdlComment(pass, "with the following generated units;");
        } else if (thisUnitName.equals(unitSName)) {
            this.writeIdlComment(pass, "This unit implements the server-side skeleton classes and must be used with");
            this.writeIdlComment(pass, "the following generated units;");
        } else if (thisUnitName.equals(unitPName)) {
            this.writeIdlComment(pass, "This unit supports the user-coded server implementation classes and must be");
            this.writeIdlComment(pass, "used with the following generated units;");
        }
        if (!thisUnitName.equals(unitIName)) {
            this.writeIdlComment(pass, "* interface unit      : ".concat(String.valueOf(unitIName)));
        }
        if (!thisUnitName.equals(unitCName)) {
            this.writeIdlComment(pass, "* client unit         : ".concat(String.valueOf(unitCName)));
        }
        if (!thisUnitName.equals(unitSName)) {
            this.writeIdlComment(pass, "* server unit         : ".concat(String.valueOf(unitSName)));
        }
        if (!thisUnitName.equals(unitPName)) {
            this.writeIdlComment(pass, "* implementation unit : ".concat(String.valueOf(unitPName)));
        }
    }

    private final void writeGuid(PInterfaceNode def) {
        try {
            MessageDigest guidMD = MessageDigest.getInstance("MD5");
            guidMD.update(def.pascalFullName.getBytes());
            this.calcMethodGuids(def._beMethods, guidMD, 12);
            this.println(String.valueOf(new StringBuffer("['{").append(this.formatGuid(guidMD)).append("}']")));
        }
        catch (Exception NoSuchAlgorihmException) {
            this._ER.internalError("invalid GUID digest Algorihm in calcGuid(PInterfaceNode)");
        }
    }

    private final void writeGuid(PStructNode def) {
        try {
            MessageDigest guidMD = MessageDigest.getInstance("MD5");
            guidMD.update(def.pascalFullName.getBytes());
            this.calcMethodGuids(def.pascalMembers, guidMD, 12);
            this.println(String.valueOf(new StringBuffer("['{").append(this.formatGuid(guidMD)).append("}']")));
        }
        catch (Exception NoSuchAlgorihmException) {
            this._ER.internalError("invalid GUID digest Algorihm in calcGuid(PStructNode)");
        }
    }

    private final void writeGuid(PUnionNode def) {
        try {
            MessageDigest guidMD = MessageDigest.getInstance("MD5");
            guidMD.update(def.pascalFullName.getBytes());
            this.calcMethodGuids(def.pascalMembers, guidMD, 12);
            this.println(String.valueOf(new StringBuffer("['{").append(this.formatGuid(guidMD)).append("}']")));
        }
        catch (Exception NoSuchAlgorihmException) {
            this._ER.internalError("invalid GUID digest Algorihm in calcGuid(PUnionNode)");
        }
    }

    private final void writeHookMethods(PInterfaceNode def, int mode) {
        ContainedNode[] methods = def._beMethods;
        if (methods != null) {
            int len = methods.length;
            block4: for (int i = 0; i < len; ++i) {
                switch (methods[i]._kind) {
                    case 7: {
                        this.usePascalInterfacePropertyMethodsBuffer(this._pass, def);
                        this.writeMethod((POperationNode)methods[i], mode);
                        continue block4;
                    }
                    case 2: {
                        this.usePascalPropertyMethodsBuffer(this._pass, def);
                        this.writeMethod((PAttributeNode)methods[i], mode);
                        continue block4;
                    }
                    default: {
                        this._ER.internalError(String.valueOf(new StringBuffer("invalid kind ").append(methods[i]._kind).append(" passed to PascalBackend.writeHookMethods (PInterfaceNode, int)")));
                    }
                }
            }
        }
    }

    private final void writeIdlComment(int pass, String comment) {
        if (this._options.idlHints) {
            this.writeIdlFixedComment(pass, comment);
        }
    }

    private final void writeIdlComment(String comment) {
        if (this._options.idlHints) {
            this.writeIdlComment(this._pass, comment);
        }
    }

    private final void writeIdlFixedComment(int pass, String comment) {
        this.println(pass, this.padCommentToLength(comment));
    }

    private final void writeIdlSectionComment(int pass, ContainedNode def) {
        Object temp = null;
        if (this._options.idlHints) {
            this.println(this.padCommentToLength("IDL Source    : ", String.valueOf(new StringBuffer("\"").append(def.ER().getFileName(def._fileNumber)).append("\", line ").append(def._lineNumber))));
            this.println(this.padCommentToLength("Repository Id : ", String.valueOf(new StringBuffer("\"").append(def._repId).append("\""))));
            this.println(this.padCommentToLength("IDL Type      : ", def.typeName()));
        }
    }

    private final void writeIdlSectionComment(int pass, ContainedNode def, String altComment) {
        if (this._options.codeHints) {
            this.newLine(pass);
        }
        this.writeIdlComment(pass, altComment);
        this.writeIdlSectionComment(pass, def);
    }

    private final void writeIdlSectionComment(ContainedNode def) {
        this.writeIdlSectionComment(this._pass, def);
    }

    private final void writeIdlSectionComment(ContainedNode def, String altComment) {
        this.writeIdlSectionComment(this._pass, def, altComment);
    }

    private final void writeIdlSectionComment(ContainedNode def, String title1, String datum1) {
        this.writeIdlSectionComment(def, title1, datum1, "", "", "", "");
    }

    private final void writeIdlSectionComment(ContainedNode def, String title1, String datum1, String title2, String datum2) {
        this.writeIdlSectionComment(def, title1, datum1, title2, datum2, "", "");
    }

    private final void writeIdlSectionComment(ContainedNode def, String title1, String datum1, String title2, String datum2, String title3, String datum3) {
        if (this._options.codeHints) {
            this.newLine(this._pass);
            this.writeComments(this._pass, title1, datum1, title2, datum2, title3, datum3);
        }
        this.writeIdlSectionComment(this._pass, def);
    }

    private final void writeIdlSectionComment(String title1, String datum1, String title2, String datum2) {
        this.writeComments(this._pass, title1, datum1, title2, datum2, "", "");
    }

    private void writeIfaceInheritance(PInterfaceNode def) {
        if (def._bases.size() > 0) {
            this.addln(String.valueOf(new StringBuffer(" (").append(((PInterfaceNode)def._bases.elementAt((int)0)).pascalFullName).append(")")));
        } else {
            this.newLine();
        }
    }

    private void writeImplImlpMethod(PInterfaceNode ifn, PMethod def, int methodType, int mode) {
        ContainedNode TempCN = def.node;
        PInterfaceNode TempPIN = (PInterfaceNode)TempCN._container;
        this.newLine();
        this.print(this.writeMethodTypeText(def));
        switch (methodType) {
            case 101: {
                this.add(TempPIN.pascalImplName);
                break;
            }
            case 102: {
                this.add(ifn.pascalImplName);
                break;
            }
        }
        this.add(String.valueOf(new StringBuffer(".").append(def.pascalImplName).append(" ")));
        if (def.pascalParamNames.length > 0) {
            this.add("(");
            int $position1 = this.horizPos();
            for (int index0 = 0; index0 < def.pascalParamTypeNames.length; ++index0) {
                this.add(String.valueOf(new StringBuffer(" ").append(def.pascalParamDirections[index0]).append(" ").append(def.pascalParamNames[index0]).append(" : ").append(def.pascalParamTypeNames[index0])));
                if (index0 >= def.pascalParamTypeNames.length - 1) continue;
                this.add(";");
                this.newLine();
                this.indentTo($position1);
            }
            this.add(")");
        }
        if (def.hasReturnValue) {
            this.add(": ".concat(String.valueOf(this.writeReturnText(def, mode))));
        }
        this.addln(";");
        this.println("begin");
        this.indent(1);
        this.println("{ *************************** }");
        this.println("{ *** User code goes here *** }");
        this.println("{ *************************** }");
        this.indent(-1);
        this.println("end;");
    }

    private void writeImplImplMethod(PInterfaceNode ifn, PMethod def, int methodType, int mode) {
        ContainedNode TempCN = def.node;
        PInterfaceNode TempPIN = (PInterfaceNode)TempCN._container;
        this.newLine();
        this.print(this.writeMethodTypeText(def));
        switch (methodType) {
            case 101: {
                this.add(TempPIN.pascalImplName);
                break;
            }
            case 102: {
                this.add(ifn.pascalImplName);
                break;
            }
        }
        this.add(String.valueOf(new StringBuffer(".").append(def.pascalImplName).append(" ")));
        if (def.pascalParamNames.length > 0) {
            this.add("(");
            int $position1 = this.horizPos();
            for (int index0 = 0; index0 < def.pascalParamTypeNames.length; ++index0) {
                this.add(String.valueOf(new StringBuffer(" ").append(def.pascalParamDirections[index0]).append(" ").append(def.pascalParamNames[index0]).append(" : ").append(def.pascalParamTypeNames[index0])));
                if (index0 >= def.pascalParamTypeNames.length - 1) continue;
                this.add(";");
                this.newLine();
                this.indentTo($position1);
            }
            this.add(")");
        }
        if (def.hasReturnValue) {
            this.add(": ".concat(String.valueOf(this.writeReturnText(def, mode))));
        }
        this.addln(";");
        this.println("begin");
        this.indent(1);
        this.println("{ *************************** }");
        this.println("{ *** User code goes here *** }");
        this.println("{ *************************** }");
        this.indent(-1);
        this.println("end;");
    }

    private void writeImplInheritance(PInterfaceNode def) {
        this.add("(");
        if (def.pascalBases.length == 0) {
            this.add("TInterfacedObject");
            this.add(", ".concat(String.valueOf(def.pascalFullName)));
        } else if (def.pascalBases.length == 1) {
            this.add("TInterfacedObject");
            this.add(", ".concat(String.valueOf(def.pascalFullName)));
        } else {
            this.add(((PInterfaceNode)def._bases.elementAt((int)0)).pascalImplFullName);
            for (int i = 1; i < def._bases.size(); ++i) {
                this.add(", ".concat(String.valueOf(def.pascalBases[i].pascalFullName)));
            }
            this.add(", ".concat(String.valueOf(def.pascalFullName)));
        }
        this.addln(")");
    }

    private void writeImplPropertyProxyMethod(PMethod def, int mode) {
        switch (mode) {
            case 82: {
                ContainedNode TempCN = null;
                PInterfaceNode TempPIN = null;
                TempCN = def.node;
                TempPIN = (PInterfaceNode)TempCN._container;
                this.newLine();
                this.print(String.valueOf(new StringBuffer(String.valueOf(this.writeMethodTypeText(def))).append(TempPIN.pascalImplName).append(".").append(def.pascalImplName).append(" ")));
                if (def.pascalParamNames.length > 0) {
                    this.add("(");
                    int $position1 = this.horizPos();
                    for (int index0 = 0; index0 < def.pascalParamTypeNames.length; ++index0) {
                        this.add(String.valueOf(new StringBuffer(" ").append(def.pascalParamDirections[index0]).append(" ").append(def.pascalParamNames[index0]).append(" : ").append(def.pascalParamTypeNames[index0])));
                        if (index0 >= def.pascalParamTypeNames.length - 1) continue;
                        this.add(";");
                        this.newLine();
                        this.indentTo($position1);
                    }
                    this.add(")");
                }
                if (def.hasReturnValue) {
                    this.add(": ".concat(String.valueOf(this.writeReturnText(def, mode))));
                }
                this.addln(";");
                this.println("begin");
                this.indent(1);
                this.println("{ *************************** }");
                this.println("{ *** Optional user code  *** }");
                this.println("{ ***      goes here      *** }");
                this.println("{ *************************** }");
                if (def.hasReturnValue) {
                    this.println(String.valueOf(new StringBuffer("Result := _").append(def.pascalName.substring(5)).append(";")));
                } else {
                    this.println(String.valueOf(new StringBuffer("_").append(def.pascalParamNames[0]).append(" := ").append(def.pascalParamNames[0]).append(";")));
                }
                this.indent(-1);
                this.println("end;");
                break;
            }
        }
    }

    private void writeImplProxyAttributes(PInterfaceNode def, int mode) {
        ContainedNode[] methods = def._beMethods;
        if (methods != null) {
            int len = methods.length;
            block4: for (int i = 0; i < len; ++i) {
                switch (methods[i]._kind) {
                    case 7: {
                        continue block4;
                    }
                    case 2: {
                        this.usePascalInterfacePropertyMethodsBuffer(this._pass, def);
                        this.writePropertyField((PAttributeNode)methods[i], mode);
                        continue block4;
                    }
                    default: {
                        this._ER.internalError(String.valueOf(new StringBuffer("invalid kind ").append(methods[i]._kind).append(" passed to PascalBackend.writeImplProxyAttributes(PInterfaceNode, int)")));
                    }
                }
            }
        }
    }

    private final void writeInheritedHookMethods(PInterfaceNode def, int mode) {
        ContainedNode[] methods = def.pascalInheritedMethods;
        if (methods != null) {
            int len = methods.length;
            block4: for (int i = 0; i < len; ++i) {
                switch (methods[i]._kind) {
                    case 7: {
                        this.usePascalInterfacePropertyMethodsBuffer(this._pass, def);
                        this.writeSecondaryMethod(def, ((POperationNode)methods[i]).pascalMethod, mode);
                        continue block4;
                    }
                    case 2: {
                        this.usePascalPropertyMethodsBuffer(this._pass, def);
                        this.writeSecondaryMethods(def, (PAttributeNode)methods[i], mode);
                        continue block4;
                    }
                    default: {
                        this._ER.internalError(String.valueOf(new StringBuffer("invalid kind ").append(methods[i]._kind).append(" passed to writeSecondaryHookMethods (PInterfaceNode, int)")));
                    }
                }
            }
        }
    }

    private void writeInheritedMethod(PInterfaceNode ifn, PMethod def, int mode) {
        this.writeSecondaryMethod(ifn, def, mode);
    }

    private final void writeInheritedMethods(PInterfaceNode def, int mode) {
        ContainedNode[] methods = def.pascalInheritedMethods;
        if (methods != null) {
            int len = methods.length;
            block4: for (int i = 0; i < len; ++i) {
                switch (methods[i]._kind) {
                    case 7: {
                        this.usePascalInterfaceMethodsBuffer(this._pass, def);
                        this.writeSecondaryMethod(def, ((POperationNode)methods[i]).pascalMethod, mode);
                        continue block4;
                    }
                    case 2: {
                        if (mode == 55) {
                            this.usePascalInterfaceMethodsBuffer(this._pass, def);
                        } else {
                            this.usePascalPropertyMethodsBuffer(this._pass, def);
                        }
                        this.writeSecondaryMethods(def, (PAttributeNode)methods[i], mode);
                        this.usePascalPropertiesBuffer(this._pass, def);
                        this.writeSecondaryProperty(def, (PAttributeNode)methods[i], mode);
                        continue block4;
                    }
                    default: {
                        this._ER.internalError(String.valueOf(new StringBuffer("invalid kind ").append(methods[i]._kind).append(" passed to genSecondaryMethods (PInterfacesNode, PInterfaceNode, int)")));
                    }
                }
            }
        }
    }

    private final void writeInheritedMethods(PInterfaceNode inf, PAttributeNode def, int mode) {
        this.writeSecondaryMethods(inf, def, mode);
    }

    private final void writeInheritedProperty(PInterfaceNode inf, PAttributeNode def, int mode) {
        this.writeSecondaryProperty(inf, def, mode);
    }

    private final void writeMethod(PAttributeNode def, int mode) {
        switch (mode) {
            case 11: 
            case 31: 
            case 34: 
            case 55: 
            case 81: {
                this.writeMethod(def.pascalGetMethod, mode);
                if (def._readOnly) break;
                this.writeMethod(def.pascalSetMethod, mode);
                break;
            }
            case 35: {
                this.writeMethod(def.pascalGetMethod, mode);
                break;
            }
            case 83: {
                break;
            }
            case 33: 
            case 56: 
            case 71: 
            case 72: {
                this.newLine();
                this.writeMethod(def.pascalGetMethod, mode);
                if (def._readOnly) break;
                this.newLine();
                this.writeMethod(def.pascalSetMethod, mode);
                break;
            }
            case 82: {
                this.newLine();
                this.writeImplPropertyProxyMethod(def.pascalGetMethod, mode);
                if (def._readOnly) break;
                this.newLine();
                this.writeImplPropertyProxyMethod(def.pascalSetMethod, mode);
                break;
            }
            case 36: {
                this.newLine();
                this.writeMethod(def.pascalGetMethod, mode);
                break;
            }
            case 53: 
            case 54: {
                break;
            }
            default: {
                this._ER.internalError(String.valueOf(new StringBuffer("invalid mode ").append(mode).append(" passed to writeMethod(PAttributeNode, int)")));
            }
        }
    }

    private final void writeMethod(PMethod def, int mode) {
        switch (mode) {
            case 11: {
                this.indent(2);
                this.print(String.valueOf(new StringBuffer(String.valueOf(this.writeMethodTypeText(def))).append(def.pascalName).append(" ")));
                if (def.pascalParamNames != null && def.pascalParamNames.length > 0) {
                    this.add("(");
                    int $position0 = this.horizPos();
                    for (int index0 = 0; index0 < def.pascalParamNames.length; ++index0) {
                        this.add(String.valueOf(new StringBuffer(String.valueOf(def.pascalParamDirections[index0])).append(" ").append(def.pascalParamNames[index0]).append(" : ").append(def.pascalParamTypeNames[index0])));
                        if (index0 >= def.pascalParamNames.length - 1) continue;
                        this.add(";");
                        this.newLine();
                        this.indentTo($position0);
                    }
                    this.add(")");
                }
                if (def.hasReturnValue) {
                    this.add(": ".concat(String.valueOf(def.pascalResultTypeName)));
                }
                this.addln(";");
                this.indent(-2);
                break;
            }
            case 31: {
                this.indent(2);
                this.print(String.valueOf(new StringBuffer(String.valueOf(this.writeMethodTypeText(def))).append(def.pascalName).append(" ")));
                if (def.pascalParamNames.length > 0) {
                    this.add("(");
                    int $position1 = this.horizPos();
                    for (int index0 = 0; index0 < def.pascalParamTypeNames.length; ++index0) {
                        this.add(String.valueOf(new StringBuffer(" ").append(def.pascalParamDirections[index0]).append(" ").append(def.pascalParamNames[index0]).append(" : ").append(def.pascalParamTypeNames[index0])));
                        if (index0 >= def.pascalParamTypeNames.length - 1) continue;
                        this.add(";");
                        this.newLine();
                        this.indentTo($position1);
                    }
                    this.add(")");
                }
                if (def.hasReturnValue) {
                    this.add(": ".concat(String.valueOf(this.writeReturnText(def, mode))));
                }
                this.addln("; virtual;");
                this.indent(-2);
                break;
            }
            case 34: {
                this.indent(2);
                this.print(String.valueOf(new StringBuffer(String.valueOf(this.writeMethodTypeText(def))).append(def.pascalName).append(" ")));
                if (def.hasReturnValue) {
                    this.addln(String.valueOf(new StringBuffer(": ").append(this.writeReturnText(def, mode)).append("; virtual;")));
                } else {
                    this.addln(String.valueOf(new StringBuffer("( ").append(def.pascalParamDirections[0]).append(" _value : ").append(def.pascalParamTypeNames[0]).append(" ); virtual;")));
                }
                this.indent(-2);
                break;
            }
            case 35: {
                this.indent(2);
                this.print("function  ".concat(String.valueOf(def.pascalName)));
                if (def.hasReturnValue) {
                    this.add(" : ".concat(String.valueOf(this.writeReturnText(def, mode))));
                }
                this.addln("; virtual;");
                this.indent(-2);
                break;
            }
            case 36: {
                this.newLine();
                this.print(String.valueOf(new StringBuffer("function  ").append(def.pascalExceptionName).append(".").append(def.pascalName)));
                if (def.hasReturnValue) {
                    this.add(" : ".concat(String.valueOf(this.writeReturnText(def, mode))));
                }
                this.addln(";");
                this.println("begin");
                this.indent(1);
                this.println(String.valueOf(new StringBuffer("Result := ").append(def.pascalFieldName).append(";")));
                this.indent(-1);
                this.println("end;");
                this.newLine();
                break;
            }
            case 33: {
                int i;
                ContainedNode TempCN = null;
                PInterfaceNode TempPIN = null;
                this.newLine();
                this.print(this.writeMethodTypeText(def));
                TempCN = def.node;
                TempPIN = (PInterfaceNode)TempCN._container;
                this.add(String.valueOf(new StringBuffer(String.valueOf(TempPIN.pascalStubName)).append(".").append(def.pascalName).append(" ")));
                if (def.pascalParamNames.length > 0) {
                    this.add("(");
                    int $position2 = this.horizPos();
                    for (int index0 = 0; index0 < def.pascalParamTypeNames.length; ++index0) {
                        this.add(String.valueOf(new StringBuffer(" ").append(def.pascalParamDirections[index0]).append(" ").append(def.pascalParamNames[index0]).append(" : ").append(def.pascalParamTypeNames[index0])));
                        if (index0 >= def.pascalParamTypeNames.length - 1) continue;
                        this.add(";");
                        this.newLine();
                        this.indentTo($position2);
                    }
                    this.add(")");
                }
                if (def.hasReturnValue) {
                    this.add(": ".concat(String.valueOf(this.writeReturnText(def, mode))));
                }
                this.addln(";");
                this.println("var");
                this.indent(1);
                this.println("_Output: CORBA.OutputStream;");
                this.println("_Input : CORBA.InputStream;");
                this.indent(-1);
                this.println("begin");
                this.indent(1);
                this.print(String.valueOf(new StringBuffer("inherited _CreateRequest('").append(def.pascalWireName).append("',")));
                this.add(!def.oneway ? "True" : "False");
                this.addln(", _Output);");
                for (i = 0; i < def.pascalParamTypeNames.length; ++i) {
                    if (def.pascalParamModes[i] != 0 && def.pascalParamModes[i] != 2) continue;
                    if (def.pascalParamHelperFullNames[i] != null) {
                        this.println(String.valueOf(new StringBuffer(String.valueOf(def.pascalParamHelperFullNames[i])).append(".Write(_Output, ").append(def.pascalParamNames[i]).append(");")));
                        continue;
                    }
                    this.writeWriteRangeCheck(def.pascalParamTypes[i], def.pascalParamNames[i], String.valueOf(new StringBuffer(String.valueOf(TempPIN.pascalStubName)).append(".").append(def.pascalFullName)));
                    this.println(String.valueOf(new StringBuffer("_Output.Write").append(def.pascalParamReadWritePrefixes[i]).append("(").append(def.pascalParamNames[i]).append(");")));
                }
                this.println("inherited _Invoke(_Output, _Input);");
                if (def.hasReturnValue) {
                    if (def.pascalReturnHelperFullName != null) {
                        this.println(String.valueOf(new StringBuffer("Result := ").append(def.pascalReturnHelperFullName).append(".Read(_Input);")));
                    } else {
                        this.println(String.valueOf(new StringBuffer("_Input.Read").append(def.pascalReturnReadWritePrefix).append("(Result);")));
                        this.writeReadRangeCheck(def.pascalResultType, "Result", String.valueOf(new StringBuffer(String.valueOf(TempPIN.pascalStubName)).append(".").append(def.pascalFullName)));
                    }
                }
                for (i = 0; i < def.pascalParamTypeNames.length; ++i) {
                    if (def.pascalParamModes[i] != 1 && def.pascalParamModes[i] != 2) continue;
                    if (def.pascalParamHelperFullNames[i] != null) {
                        this.println(String.valueOf(new StringBuffer(String.valueOf(def.pascalParamNames[i])).append(" := ").append(def.pascalParamHelperFullNames[i]).append(".Read(_Input);")));
                        continue;
                    }
                    this.println(String.valueOf(new StringBuffer("_Input.Read").append(def.pascalParamReadWritePrefixes[i]).append("(").append(def.pascalParamNames[i]).append(");")));
                    this.writeReadRangeCheck(def.pascalParamTypes[i], def.pascalParamNames[i], String.valueOf(new StringBuffer(String.valueOf(TempPIN.pascalStubName)).append(".").append(def.pascalFullName)));
                }
                this.indent(-1);
                this.println("end;");
                break;
            }
            case 71: {
                int index0;
                int $position2;
                ContainedNode TempCN = null;
                PInterfaceNode TempPIN = null;
                this.newLine();
                this.print(this.writeMethodTypeText(def));
                TempCN = def.node;
                TempPIN = (PInterfaceNode)TempCN._container;
                this.add(String.valueOf(new StringBuffer(String.valueOf(TempPIN.pascalSkeletonName)).append(".").append(def.pascalName).append(" ")));
                if (def.pascalParamNames.length > 0) {
                    this.add("(");
                    $position2 = this.horizPos();
                    for (index0 = 0; index0 < def.pascalParamTypeNames.length; ++index0) {
                        this.add(String.valueOf(new StringBuffer(" ").append(def.pascalParamDirections[index0]).append(" ").append(def.pascalParamNames[index0]).append(" : ").append(def.pascalParamTypeNames[index0])));
                        if (index0 >= def.pascalParamTypeNames.length - 1) continue;
                        this.add(";");
                        this.newLine();
                        this.indentTo($position2);
                    }
                    this.add(")");
                }
                if (def.hasReturnValue) {
                    this.add(": ".concat(String.valueOf(this.writeReturnText(def, mode))));
                }
                this.addln(";");
                this.println("begin");
                this.indent(1);
                if (def.hasReturnValue) {
                    this.print("Result := ");
                } else {
                    this.print("");
                }
                this.add("FImplementation.".concat(String.valueOf(def.pascalName)));
                if (def.pascalParamNames.length > 0) {
                    this.add("(");
                    $position2 = this.horizPos();
                    for (index0 = 0; index0 < def.pascalParamTypeNames.length; ++index0) {
                        this.add(" ".concat(String.valueOf(def.pascalParamNames[index0])));
                        if (index0 >= def.pascalParamTypeNames.length - 1) continue;
                        this.add(",");
                        this.newLine();
                        this.indentTo($position2);
                    }
                    this.add(")");
                }
                this.addln(";");
                this.indent(-1);
                this.println("end;");
                break;
            }
            case 72: {
                int i;
                ContainedNode TempCN = null;
                PInterfaceNode TempPIN = null;
                TempCN = def.node;
                TempPIN = (PInterfaceNode)TempCN._container;
                this.newLine();
                this.println(String.valueOf(new StringBuffer("procedure ").append(TempPIN.pascalSkeletonName).append(".").append(def.pascalSkeletonMarshalName).append("(const _Input: CORBA.InputStream; _Cookie: Pointer);")));
                this.println("var");
                this.indent(1);
                this.println("_Output : CORBA.OutputStream;");
                if (def.pascalParamNames.length > 0) {
                    for (int index0 = 0; index0 < def.pascalParamTypeNames.length; ++index0) {
                        this.println(String.valueOf(new StringBuffer("_").append(def.pascalParamNames[index0]).append(" : ").append(def.pascalParamTypeNames[index0]).append(";")));
                    }
                }
                if (def.hasReturnValue) {
                    this.println(String.valueOf(new StringBuffer("_Result : ").append(this.writeReturnText(def, mode)).append(";")));
                }
                this.indent(-1);
                this.println("begin");
                this.indent(1);
                for (i = 0; i < def.pascalParamTypeNames.length; ++i) {
                    if (def.pascalParamModes[i] != 0 && def.pascalParamModes[i] != 2) continue;
                    if (def.pascalParamHelperFullNames[i] != null) {
                        this.println(String.valueOf(new StringBuffer("_").append(def.pascalParamNames[i]).append(" := ").append(def.pascalParamHelperFullNames[i]).append(".Read(_Input);")));
                        continue;
                    }
                    this.println(String.valueOf(new StringBuffer("_Input.Read").append(def.pascalParamReadWritePrefixes[i]).append("(_").append(def.pascalParamNames[i]).append(");")));
                    this.writeReadRangeCheck(def.pascalParamTypes[i], "_".concat(String.valueOf(def.pascalParamNames[i])), String.valueOf(new StringBuffer(String.valueOf(TempPIN.pascalStubName)).append(".").append(def.pascalFullName)));
                }
                if (def.pascalExceptions.length > 0) {
                    this.println("try");
                    this.indent(1);
                }
                if (def.hasReturnValue) {
                    this.print("_Result := ");
                } else {
                    this.print("");
                }
                this.add(def.pascalName);
                if (def.pascalParamNames.length > 0) {
                    this.add("(");
                    int $position2 = this.horizPos();
                    for (int index0 = 0; index0 < def.pascalParamTypeNames.length; ++index0) {
                        this.add(" _".concat(String.valueOf(def.pascalParamNames[index0])));
                        if (index0 >= def.pascalParamTypeNames.length - 1) continue;
                        this.add(",");
                        this.newLine();
                        this.indentTo($position2);
                    }
                    this.add(")");
                }
                this.addln(";");
                if (def.pascalExceptions.length > 0) {
                    this.indent(-1);
                }
                if (def.pascalExceptions.length > 0) {
                    this.println("except on E: UserException do");
                    this.indent(1);
                    this.println("begin");
                    this.indent(1);
                    this.println("GetExceptionReplyBuffer(_Cookie, _Output);");
                    this.println("E.WriteExceptionInfo(_Output);");
                    this.println("exit");
                    this.indent(-1);
                    this.println("end;");
                    this.indent(-1);
                    this.println("end;");
                }
                this.println("GetReplyBuffer(_Cookie, _Output);");
                if (def.hasReturnValue) {
                    if (def.pascalReturnHelperFullName != null) {
                        this.println(String.valueOf(def.pascalReturnHelperFullName).concat(".Write(_Output, _Result);"));
                    } else {
                        this.writeWriteRangeCheck(def.pascalResultType, "_Result", String.valueOf(new StringBuffer(String.valueOf(TempPIN.pascalStubName)).append(".").append(def.pascalFullName)));
                        this.println(String.valueOf(new StringBuffer("_Output.Write").append(def.pascalReturnReadWritePrefix).append("(_Result);")));
                    }
                }
                for (i = 0; i < def.pascalParamTypeNames.length; ++i) {
                    if (def.pascalParamModes[i] != 1 && def.pascalParamModes[i] != 2) continue;
                    if (def.pascalParamHelperFullNames[i] != null) {
                        this.println(String.valueOf(new StringBuffer(String.valueOf(def.pascalParamHelperFullNames[i])).append(".Write(_Output, ").append("_").append(def.pascalParamNames[i]).append(");")));
                        continue;
                    }
                    this.println(String.valueOf(new StringBuffer("_Output.Write").append(def.pascalParamReadWritePrefixes[i]).append("(").append("_").append(def.pascalParamNames[i]).append(");")));
                    this.writeReadRangeCheck(def.pascalParamTypes[i], "_".concat(String.valueOf(def.pascalParamNames[i])), String.valueOf(new StringBuffer(String.valueOf(TempPIN.pascalStubName)).append(".").append(def.pascalFullName)));
                }
                this.indent(-1);
                this.println("end;");
                break;
            }
            case 55: {
                this.indent(2);
                this.print(String.valueOf(new StringBuffer(String.valueOf(this.writeMethodTypeText(def))).append(def.pascalName).append(" ")));
                if (def.pascalParamNames.length > 0) {
                    this.add("(");
                    int $position1 = this.horizPos();
                    for (int index0 = 0; index0 < def.pascalParamTypeNames.length; ++index0) {
                        this.add(String.valueOf(new StringBuffer(" ").append(def.pascalParamDirections[index0]).append(" ").append(def.pascalParamNames[index0]).append(" : ").append(def.pascalParamTypeNames[index0])));
                        if (index0 >= def.pascalParamTypeNames.length - 1) continue;
                        this.add(";");
                        this.newLine();
                        this.indentTo($position1);
                    }
                    this.add(")");
                }
                if (def.hasReturnValue) {
                    this.add(": ".concat(String.valueOf(this.writeReturnText(def, mode))));
                }
                this.addln(";");
                this.indent(-2);
                break;
            }
            case 56: {
                this.indent(2);
                this.println(String.valueOf(new StringBuffer("procedure ").append(def.pascalSkeletonMarshalName).append("(const _Input: CORBA.InputStream; _Cookie: Pointer);")));
                this.indent(-2);
                break;
            }
            case 81: {
                this.indent(2);
                this.print(String.valueOf(new StringBuffer(String.valueOf(this.writeMethodTypeText(def))).append(def.pascalName).append(" ")));
                if (def.pascalParamNames.length > 0) {
                    this.add("(");
                    int $position1 = this.horizPos();
                    for (int index0 = 0; index0 < def.pascalParamTypeNames.length; ++index0) {
                        this.add(String.valueOf(new StringBuffer(" ").append(def.pascalParamDirections[index0]).append(" ").append(def.pascalParamNames[index0]).append(" : ").append(def.pascalParamTypeNames[index0])));
                        if (index0 >= def.pascalParamTypeNames.length - 1) continue;
                        this.add(";");
                        this.newLine();
                        this.indentTo($position1);
                    }
                    this.add(")");
                }
                if (def.hasReturnValue) {
                    this.add(": ".concat(String.valueOf(this.writeReturnText(def, mode))));
                }
                this.addln(";");
                this.indent(-2);
                break;
            }
            case 82: {
                ContainedNode TempCN = null;
                PInterfaceNode TempPIN = null;
                TempCN = def.node;
                TempPIN = (PInterfaceNode)TempCN._container;
                this.newLine();
                this.print(String.valueOf(new StringBuffer(String.valueOf(this.writeMethodTypeText(def))).append(TempPIN.pascalImplName).append(".").append(def.pascalImplName).append(" ")));
                if (def.pascalParamNames.length > 0) {
                    this.add("(");
                    int $position1 = this.horizPos();
                    for (int index0 = 0; index0 < def.pascalParamTypeNames.length; ++index0) {
                        this.add(String.valueOf(new StringBuffer(" ").append(def.pascalParamDirections[index0]).append(" ").append(def.pascalParamNames[index0]).append(" : ").append(def.pascalParamTypeNames[index0])));
                        if (index0 >= def.pascalParamTypeNames.length - 1) continue;
                        this.add(";");
                        this.newLine();
                        this.indentTo($position1);
                    }
                    this.add(")");
                }
                if (def.hasReturnValue) {
                    this.add(": ".concat(String.valueOf(this.writeReturnText(def, mode))));
                }
                this.addln(";");
                this.println("begin");
                this.indent(1);
                this.println("{ *************************** }");
                this.println("{ *** User code goes here *** }");
                this.println("{ *************************** }");
                this.indent(-1);
                this.println("end;");
                break;
            }
            case 83: {
                break;
            }
            default: {
                this._ER.internalError(String.valueOf(new StringBuffer("invalid mode ").append(mode).append(" passed to writeMethod(PMethod, int)")));
            }
        }
    }

    private final void writeMethod(POperationNode def, int mode) {
        int _indent = -1;
        switch (mode) {
            case 11: 
            case 31: 
            case 81: {
                _indent = 2;
                break;
            }
            case 33: 
            case 55: 
            case 56: 
            case 71: 
            case 72: 
            case 82: {
                _indent = 1;
                break;
            }
            case 83: {
                break;
            }
            default: {
                this._ER.internalError(String.valueOf(new StringBuffer("invalid mode ").append(mode).append(" passed to writeMethod(POperationNode)")));
            }
        }
        if (_indent > -1) {
            this.indent(_indent);
            this.writeIdlSectionComment(def);
            this.indent(-1 * _indent);
            this.writeMethod(def.pascalMethod, mode);
        }
    }

    private String writeMethodTypeText(PMethod def) {
        return def.hasReturnValue ? "function  " : "procedure ";
    }

    private final void writeMethods(PExceptionNode def, int mode) {
        PAttributeNode[] methods = def.pascalMembers;
        def.componentBuffers.reset(this._pass);
        if (methods != null) {
            int len = methods.length;
            for (int i = 0; i < len; ++i) {
                this.usePascalPropertyMethodsBuffer(this._pass, def);
                this.writeMethod(methods[i], mode);
                this.usePascalPropertiesBuffer(this._pass, def);
                this.writeProperty(methods[i], mode);
                this.usePascalExceptionFieldsBuffer(this._pass, def);
                this.writePropertyField(methods[i], mode);
            }
        }
    }

    private final void writeMethods(PInterfaceNode def, int mode) {
        ContainedNode[] methods = def._beMethods;
        if (methods != null) {
            int len = methods.length;
            block4: for (int i = 0; i < len; ++i) {
                switch (methods[i]._kind) {
                    case 7: {
                        this.usePascalInterfaceMethodsBuffer(this._pass, def);
                        this.writeMethod((POperationNode)methods[i], mode);
                        continue block4;
                    }
                    case 2: {
                        if (mode == 55) {
                            this.usePascalInterfaceMethodsBuffer(this._pass, def);
                        } else {
                            this.usePascalPropertyMethodsBuffer(this._pass, def);
                        }
                        this.writeMethod((PAttributeNode)methods[i], mode);
                        this.usePascalPropertiesBuffer(this._pass, def);
                        this.writeProperty((PAttributeNode)methods[i], mode);
                        continue block4;
                    }
                    default: {
                        this._ER.internalError(String.valueOf(new StringBuffer("invalid kind ").append(methods[i]._kind).append(" passed to writeMethods (PInterfaceNode, int)")));
                    }
                }
            }
        }
    }

    private final void writeMethods(PStructNode def, int mode) {
        PAttributeNode[] methods = def.pascalMembers;
        def.componentBuffers.reset(this._pass);
        if (methods != null) {
            int len = methods.length;
            for (int i = 0; i < len; ++i) {
                this.usePascalPropertyMethodsBuffer(this._pass, def);
                this.writeMethod(methods[i], mode);
                this.usePascalPropertiesBuffer(this._pass, def);
                this.writeProperty(methods[i], mode);
            }
        }
    }

    private final void writeMethods(PUnionNode def, int mode) {
        PAttributeNode[] methods = def.pascalMembers;
        def.componentBuffers.reset(this._pass);
        if (methods != null) {
            int len = methods.length;
            for (int i = 0; i < len; ++i) {
                this.usePascalPropertyMethodsBuffer(this._pass, def);
                this.writeMethod(methods[i], mode);
                this.usePascalPropertiesBuffer(this._pass, def);
                this.writeProperty(methods[i], mode);
            }
        }
    }

    private final void writePreambleComments(int pass, String idlFileName) {
        Date genDate = new Date();
        this.newLine(pass);
        this.writeIdlFixedComment(pass, String.valueOf(new StringBuffer("This file was generated on ").append(genDate.toGMTString()).append(" by version ").append("03.03.03.C1.A1")));
        this.writeIdlFixedComment(pass, "of the Inprise VisiBroker idl2pas CORBA IDL compiler.");
        this.newLine(pass);
        this.writeIdlFixedComment(pass, "Please do not edit the contents of this file. You should instead edit and");
        if (idlFileName.length() > 17) {
            this.writeIdlFixedComment(pass, "recompile the original IDL which was located in the file");
            this.writeIdlFixedComment(pass, String.valueOf(idlFileName).concat("."));
        } else {
            this.writeIdlFixedComment(pass, String.valueOf(new StringBuffer("recompile the original IDL which was located in the file ").append(idlFileName).append(".")));
        }
    }

    private final void writePreambleImplComments(int pass, String idlFileName) {
        Date genDate = new Date();
        this.newLine(pass);
        this.writeIdlFixedComment(pass, String.valueOf(new StringBuffer("This file was generated on ").append(genDate.toGMTString()).append(" by version ").append("03.03.03.C1.A1")));
        this.writeIdlFixedComment(pass, "of the Inprise VisiBroker idl2pas CORBA IDL compiler.");
        this.newLine(pass);
    }

    private final void writeProperty(PAttributeNode def, int mode) {
        switch (mode) {
            case 11: 
            case 31: 
            case 81: {
                this.indent(2);
                this.print(String.valueOf(new StringBuffer("property  ").append(def.pascalName).append(" : ").append(this.writeReturnText(def.pascalGetMethod, mode)).append(" read ").append(def.pascalGetMethod.pascalName)));
                if (!def._readOnly) {
                    this.add(" write ".concat(String.valueOf(def.pascalSetMethod.pascalName)));
                }
                this.addln(";");
                this.indent(-2);
                break;
            }
            case 34: {
                this.indent(2);
                this.println(String.valueOf(new StringBuffer(String.valueOf(def.pascalName)).append(" : ").append(this.writeReturnText(def.pascalGetMethod, mode)).append(";")));
                this.indent(-2);
                break;
            }
            case 35: {
                this.indent(2);
                this.print(String.valueOf(new StringBuffer("property  ").append(def.pascalName).append(" : ").append(this.writeReturnText(def.pascalGetMethod, mode)).append(" read ").append(def.pascalGetMethod.pascalName)));
                if (!def._readOnly) {
                    this.add(" write ".concat(String.valueOf(def.pascalSetMethod.pascalName)));
                }
                this.addln(";");
                this.indent(-2);
                break;
            }
            case 82: {
                this.print(String.valueOf(new StringBuffer(String.valueOf(def.pascalName)).append(" : ").append(this.writeReturnText(def.pascalGetMethod, mode)).append(";")));
                break;
            }
            case 33: 
            case 36: 
            case 53: 
            case 54: 
            case 55: 
            case 71: 
            case 72: 
            case 83: {
                break;
            }
            default: {
                this._ER.internalError(String.valueOf(new StringBuffer("invalid mode ").append(mode).append(" passed to writeProperty(final PAttributeNode, int)")));
            }
        }
    }

    private final void writePropertyField(PAttributeNode def, int mode) {
        switch (mode) {
            case 11: 
            case 31: 
            case 34: {
                break;
            }
            case 35: {
                this.indent(2);
                this.println(String.valueOf(new StringBuffer(String.valueOf(def.pascalFieldName)).append(" : ").append(this.writeReturnText(def.pascalGetMethod, mode)).append(";")));
                this.indent(-2);
                break;
            }
            case 33: 
            case 36: 
            case 53: 
            case 54: {
                break;
            }
            case 83: {
                this.indent(2);
                this.println(String.valueOf(new StringBuffer("_").append(def.pascalName).append(" : ").append(this.writeReturnText(def.pascalGetMethod, mode)).append(";")));
                this.indent(-2);
                break;
            }
            default: {
                this._ER.internalError(String.valueOf(new StringBuffer("invalid mode ").append(mode).append(" passed to genPropertyField (final PAttributeNode, int)")));
            }
        }
    }

    private void writeReadElement(PUnionNode def) {
        this.print("else ");
        if (this.needsRangeCheck(def.pascalMemberTypes[def._defaultIndex])) {
            this.println("begin");
        }
        if (def.pascalMemberHelperFullNames[def._defaultIndex] != null) {
            this.add(String.valueOf(new StringBuffer("_Value.").append(def.pascalMemberNames[def._defaultIndex]).append(" := ").append(def.pascalMemberHelperFullNames[def._defaultIndex]).append(".Read(_Input);")));
        } else {
            this.add(String.valueOf(new StringBuffer("_Input.Read").append(def.pascalMemberReadWritePrefixes[def._defaultIndex]).append("(_Value.").append(def.pascalMemberNames[def._defaultIndex]).append(");")));
        }
        this.writeReadRangeCheck(def.pascalMemberTypes[def._defaultIndex], "_Value.".concat(String.valueOf(def.pascalMemberNames[def._defaultIndex])), def.pascalFullName, true, true);
        if (this.needsRangeCheck(def.pascalMemberTypes[def._defaultIndex])) {
            this.println("end;");
        }
    }

    private void writeReadElement(PUnionNode def, int i, int j) {
        this.print(String.valueOf(def.pascalMemberLabels[i][j]).concat(" : "));
        if (this.needsRangeCheck(def.pascalMemberTypes[i])) {
            this.println("begin");
        }
        if (def.pascalMemberHelperFullNames[i] != null) {
            this.add(String.valueOf(new StringBuffer("_Value.").append(def.pascalMemberNames[i]).append(" := ").append(def.pascalMemberHelperFullNames[i]).append(".Read(_Input); ")));
        } else {
            this.add(String.valueOf(new StringBuffer("_Input.Read").append(def.pascalMemberReadWritePrefixes[i]).append("(_Value.").append(def.pascalMemberNames[i]).append("); ")));
        }
        this.writeReadRangeCheck(def.pascalMemberTypes[i], "_Value.".concat(String.valueOf(def.pascalMemberNames[i])), def.pascalFullName, true, false);
        this.newLine();
        if (this.needsRangeCheck(def.pascalMemberTypes[i])) {
            this.println("end;");
        }
    }

    private void writeReadRangeCheck(Type type, String variableName, String name) {
        this.writeReadRangeCheck(type, variableName, name, false, true);
    }

    private void writeReadRangeCheck(Type type, String variableName, String name, boolean continueLine, boolean newLine) {
        if (this.needsRangeCheck(type)) {
            if (!continueLine) {
                this.print("");
            }
            this.add(String.valueOf(new StringBuffer("if (").append(variableName).append(" < 0) then raise DATA_CONVERSION.Create(0, COMPLETED_YES);")));
            if (newLine) {
                this.newLine();
            } else {
                this.add(" ");
            }
        }
    }

    private String writeReturnText(PMethod def, int mode) {
        return def.hasReturnValue ? def.pascalResultTypeName : "";
    }

    private final void writeSecondaryHookMethods(PInterfaceNode def, int mode) {
        ContainedNode[] methods = def.pascalSecondaryMethods;
        if (methods != null) {
            int len = methods.length;
            block4: for (int i = 0; i < len; ++i) {
                switch (methods[i]._kind) {
                    case 7: {
                        this.usePascalInterfacePropertyMethodsBuffer(this._pass, def);
                        this.writeSecondaryMethod(def, ((POperationNode)methods[i]).pascalMethod, mode);
                        continue block4;
                    }
                    case 2: {
                        this.usePascalPropertyMethodsBuffer(this._pass, def);
                        this.writeSecondaryMethods(def, (PAttributeNode)methods[i], mode);
                        continue block4;
                    }
                    default: {
                        this._ER.internalError(String.valueOf(new StringBuffer("invalid kind ").append(methods[i]._kind).append(" passed to PascalBackend.writeSecondaryHookMethods(PInterfaceNode, int)")));
                    }
                }
            }
        }
    }

    private void writeSecondaryMethod(PInterfaceNode ifn, PMethod def, int mode) {
        switch (mode) {
            case 71: {
                this.writeSkelImpMethod(ifn, def, 102, mode);
                break;
            }
            case 33: {
                this.writeStubImpMethod(ifn, def, 102, mode);
                break;
            }
            case 72: {
                this.writeSkelMarshalMethod(ifn, def, 102, mode);
                break;
            }
            case 82: {
                this.writeImplImplMethod(ifn, def, 102, mode);
                break;
            }
            default: {
                this.writeMethod(def, mode);
            }
        }
    }

    private final void writeSecondaryMethods(PInterfaceNode def, int mode) {
        ContainedNode[] methods = def.pascalSecondaryMethods;
        if (methods != null) {
            int len = methods.length;
            block4: for (int i = 0; i < len; ++i) {
                switch (methods[i]._kind) {
                    case 7: {
                        this.usePascalInterfaceMethodsBuffer(this._pass, def);
                        this.writeSecondaryMethod(def, ((POperationNode)methods[i]).pascalMethod, mode);
                        continue block4;
                    }
                    case 2: {
                        if (mode == 55) {
                            this.usePascalInterfaceMethodsBuffer(this._pass, def);
                        } else {
                            this.usePascalPropertyMethodsBuffer(this._pass, def);
                        }
                        this.writeSecondaryMethods(def, (PAttributeNode)methods[i], mode);
                        this.usePascalPropertiesBuffer(this._pass, def);
                        this.writeSecondaryProperty(def, (PAttributeNode)methods[i], mode);
                        continue block4;
                    }
                    default: {
                        this._ER.internalError(String.valueOf(new StringBuffer("invalid kind ").append(methods[i]._kind).append(" passed to PascalBackend.genSecondaryMethods (PInterfacesNode, PInterfaceNode, int)")));
                    }
                }
            }
        }
    }

    private final void writeSecondaryMethods(PInterfaceNode inf, PAttributeNode def, int mode) {
        if (mode != 33) {
            this.writeMethod(def, mode);
        } else {
            this.writeSecondaryMethod(inf, def.pascalGetMethod, mode);
            if (!def._readOnly) {
                this.newLine();
                this.writeSecondaryMethod(inf, def.pascalSetMethod, mode);
            }
        }
    }

    private final void writeSecondaryProperty(PInterfaceNode inf, PAttributeNode def, int mode) {
        block0: {
            if (mode == 33) break block0;
            this.writeProperty(def, mode);
        }
    }

    private void writeSkelImpMethod(PInterfaceNode ifn, PMethod def, int methodType, int mode) {
        int index0;
        int $position2;
        ContainedNode TempCN = null;
        PInterfaceNode TempPIN = null;
        TempCN = def.node;
        TempPIN = (PInterfaceNode)TempCN._container;
        this.newLine();
        this.print(this.writeMethodTypeText(def));
        switch (methodType) {
            case 101: {
                this.add(TempPIN.pascalSkeletonName);
                break;
            }
            case 102: {
                this.add(ifn.pascalSkeletonName);
                break;
            }
        }
        this.add(String.valueOf(new StringBuffer(".").append(def.pascalName).append(" ")));
        if (def.pascalParamNames.length > 0) {
            this.add("(");
            $position2 = this.horizPos();
            for (index0 = 0; index0 < def.pascalParamTypeNames.length; ++index0) {
                this.add(String.valueOf(new StringBuffer(" ").append(def.pascalParamDirections[index0]).append(" ").append(def.pascalParamNames[index0]).append(" : ").append(def.pascalParamTypeNames[index0])));
                if (index0 >= def.pascalParamTypeNames.length - 1) continue;
                this.add(";");
                this.newLine();
                this.indentTo($position2);
            }
            this.add(")");
        }
        if (def.hasReturnValue) {
            this.add(": ".concat(String.valueOf(this.writeReturnText(def, mode))));
        }
        this.addln(";");
        this.println("begin");
        this.indent(1);
        if (def.hasReturnValue) {
            this.print("Result := ");
        } else {
            this.print("");
        }
        this.add("FImplementation.".concat(String.valueOf(def.pascalName)));
        if (def.pascalParamNames.length > 0) {
            this.add("(");
            $position2 = this.horizPos();
            for (index0 = 0; index0 < def.pascalParamTypeNames.length; ++index0) {
                this.add(" ".concat(String.valueOf(def.pascalParamNames[index0])));
                if (index0 >= def.pascalParamTypeNames.length - 1) continue;
                this.add(",");
                this.newLine();
                this.indentTo($position2);
            }
            this.add(")");
        }
        this.addln(";");
        this.indent(-1);
        this.println("end;");
    }

    private void writeSkelInheritance(PInterfaceNode def) {
        this.add("(");
        if (def.pascalBases.length == 0) {
            this.add("CORBA.TCorbaObject");
        } else if (def.pascalBases.length == 1) {
            this.add("CORBA.TCorbaObject");
        } else {
            this.add(((PInterfaceNode)def._bases.elementAt((int)0)).pascalSkeletonFullName);
        }
        this.add(", ".concat(String.valueOf(def.pascalFullName)));
        this.addln(")");
    }

    private void writeSkelMarshalMethod(PInterfaceNode ifn, PMethod def, int methodType, int mode) {
        int i;
        ContainedNode TempCN = null;
        PInterfaceNode TempPIN = null;
        TempCN = def.node;
        TempPIN = (PInterfaceNode)TempCN._container;
        this.newLine();
        this.print("procedure ");
        switch (methodType) {
            case 101: {
                this.add(TempPIN.pascalSkeletonName);
                break;
            }
            case 102: {
                this.add(ifn.pascalSkeletonName);
                break;
            }
        }
        this.addln(String.valueOf(new StringBuffer(".").append(def.pascalSkeletonMarshalName).append("(const _Input: CORBA.InputStream; _Cookie: Pointer);")));
        this.println("var");
        this.indent(1);
        this.println("_Output : CORBA.OutputStream;");
        if (def.pascalParamNames.length > 0) {
            for (int index0 = 0; index0 < def.pascalParamTypeNames.length; ++index0) {
                this.println(String.valueOf(new StringBuffer("_").append(def.pascalParamNames[index0]).append(" : ").append(def.pascalParamTypeNames[index0]).append(";")));
            }
        }
        if (def.hasReturnValue) {
            this.println(String.valueOf(new StringBuffer("_Result : ").append(this.writeReturnText(def, mode)).append(";")));
        }
        this.indent(-1);
        this.println("begin");
        this.indent(1);
        for (i = 0; i < def.pascalParamTypeNames.length; ++i) {
            if (def.pascalParamModes[i] != 0 && def.pascalParamModes[i] != 2) continue;
            if (def.pascalParamHelperFullNames[i] != null) {
                this.println(String.valueOf(new StringBuffer("_").append(def.pascalParamNames[i]).append(" := ").append(def.pascalParamHelperFullNames[i]).append(".Read(_Input);")));
                continue;
            }
            this.println(String.valueOf(new StringBuffer("_Input.Read").append(def.pascalParamReadWritePrefixes[i]).append("(_").append(def.pascalParamNames[i]).append(");")));
            this.writeReadRangeCheck(def.pascalParamTypes[i], "_".concat(String.valueOf(def.pascalParamNames[i])), String.valueOf(new StringBuffer(String.valueOf(TempPIN.pascalStubName)).append(".").append(def.pascalFullName)));
        }
        if (def.hasReturnValue) {
            this.print("_Result := ");
        } else {
            this.print("");
        }
        this.add(def.pascalName);
        if (def.pascalParamNames.length > 0) {
            this.add("(");
            int $position2 = this.horizPos();
            for (int index0 = 0; index0 < def.pascalParamTypeNames.length; ++index0) {
                this.add(" _".concat(String.valueOf(def.pascalParamNames[index0])));
                if (index0 >= def.pascalParamTypeNames.length - 1) continue;
                this.add(",");
                this.newLine();
                this.indentTo($position2);
            }
            this.add(")");
        }
        this.addln(";");
        this.println("GetReplyBuffer(_Cookie, _Output);");
        if (def.hasReturnValue) {
            if (def.pascalReturnHelperFullName != null) {
                this.println(String.valueOf(def.pascalReturnHelperFullName).concat(".Write(_Output, _Result);"));
            } else {
                this.writeWriteRangeCheck(def.pascalResultType, "_Result", String.valueOf(new StringBuffer(String.valueOf(TempPIN.pascalStubName)).append(".").append(def.pascalFullName)));
                this.println(String.valueOf(new StringBuffer("_Output.Write").append(def.pascalReturnReadWritePrefix).append("(_Result);")));
            }
        }
        for (i = 0; i < def.pascalParamTypeNames.length; ++i) {
            if (def.pascalParamModes[i] != 1 && def.pascalParamModes[i] != 2) continue;
            if (def.pascalParamHelperFullNames[i] != null) {
                this.println(String.valueOf(new StringBuffer(String.valueOf(def.pascalParamHelperFullNames[i])).append(".Write(_Output, ").append("_").append(def.pascalParamNames[i]).append(");")));
                continue;
            }
            this.println(String.valueOf(new StringBuffer("_Output.Write").append(def.pascalParamReadWritePrefixes[i]).append("(").append("_").append(def.pascalParamNames[i]).append(");")));
            this.writeReadRangeCheck(def.pascalParamTypes[i], "_".concat(String.valueOf(def.pascalParamNames[i])), String.valueOf(new StringBuffer(String.valueOf(TempPIN.pascalStubName)).append(".").append(def.pascalFullName)));
        }
        this.indent(-1);
        this.println("end;");
    }

    private void writeStubImpMethod(PInterfaceNode ifn, PMethod def, int methodType, int mode) {
        int i;
        ContainedNode TempCN = null;
        PInterfaceNode TempPIN = null;
        TempCN = def.node;
        TempPIN = (PInterfaceNode)TempCN._container;
        this.newLine();
        this.print(this.writeMethodTypeText(def));
        switch (methodType) {
            case 101: {
                this.add(TempPIN.pascalName);
                break;
            }
            case 102: {
                this.add(ifn.pascalStubName);
                break;
            }
        }
        this.add(String.valueOf(new StringBuffer(".").append(def.pascalName).append(" ")));
        if (def.pascalParamNames.length > 0) {
            this.add("(");
            int $position2 = this.horizPos();
            for (int index0 = 0; index0 < def.pascalParamTypeNames.length; ++index0) {
                this.add(String.valueOf(new StringBuffer(" ").append(def.pascalParamDirections[index0]).append(" ").append(def.pascalParamNames[index0]).append(" : ").append(def.pascalParamTypeNames[index0])));
                if (index0 >= def.pascalParamTypeNames.length - 1) continue;
                this.add(";");
                this.newLine();
                this.indentTo($position2);
            }
            this.add(")");
        }
        if (def.hasReturnValue) {
            this.add(": ".concat(String.valueOf(this.writeReturnText(def, mode))));
        }
        this.addln(";");
        this.println("var");
        this.indent(1);
        this.println("_Output: CORBA.OutputStream;");
        this.println("_Input : CORBA.InputStream;");
        this.indent(-1);
        this.println("begin");
        this.indent(1);
        this.print(String.valueOf(new StringBuffer("inherited _CreateRequest('").append(def.pascalWireName).append("',")));
        this.add(!def.oneway ? "True" : "False");
        this.addln(", _Output);");
        for (i = 0; i < def.pascalParamTypeNames.length; ++i) {
            if (def.pascalParamModes[i] != 0 && def.pascalParamModes[i] != 2) continue;
            if (def.pascalParamHelperFullNames[i] != null) {
                this.println(String.valueOf(new StringBuffer(String.valueOf(def.pascalParamHelperFullNames[i])).append(".Write(_Output, ").append(def.pascalParamNames[i]).append(");")));
                continue;
            }
            this.writeWriteRangeCheck(def.pascalParamTypes[i], def.pascalParamNames[i], String.valueOf(new StringBuffer(String.valueOf(TempPIN.pascalStubName)).append(".").append(def.pascalFullName)));
            this.println(String.valueOf(new StringBuffer("_Output.Write").append(def.pascalParamReadWritePrefixes[i]).append("(").append(def.pascalParamNames[i]).append(");")));
        }
        this.println("inherited _Invoke(_Output, _Input);");
        if (def.hasReturnValue) {
            if (def.pascalReturnHelperFullName != null) {
                this.println(String.valueOf(new StringBuffer("Result := ").append(def.pascalReturnHelperFullName).append(".Read(_Input);")));
            } else {
                this.println(String.valueOf(new StringBuffer("_Input.Read").append(def.pascalReturnReadWritePrefix).append("(Result);")));
                this.writeReadRangeCheck(def.pascalResultType, "Result", String.valueOf(new StringBuffer(String.valueOf(TempPIN.pascalStubName)).append(".").append(def.pascalFullName)));
            }
        }
        for (i = 0; i < def.pascalParamTypeNames.length; ++i) {
            if (def.pascalParamModes[i] != 1 && def.pascalParamModes[i] != 2) continue;
            if (def.pascalParamHelperFullNames[i] != null) {
                this.println(String.valueOf(new StringBuffer(String.valueOf(def.pascalParamNames[i])).append(" := ").append(def.pascalParamHelperFullNames[i]).append(".Read(_Input);")));
                continue;
            }
            this.println(String.valueOf(new StringBuffer("_Input.Read").append(def.pascalParamReadWritePrefixes[i]).append("(").append(def.pascalParamNames[i]).append(");")));
            this.writeReadRangeCheck(def.pascalParamTypes[i], def.pascalParamNames[i], String.valueOf(new StringBuffer(String.valueOf(TempPIN.pascalStubName)).append(".").append(def.pascalFullName)));
        }
        this.indent(-1);
        this.println("end;");
    }

    private void writeStubInheritance(PInterfaceNode def) {
        this.add("(");
        if (def.pascalBases.length == 0) {
            this.add("CORBA.TCORBAObject");
            this.add(", ".concat(String.valueOf(def.pascalFullName)));
        } else if (def.pascalBases.length == 1) {
            this.add("CORBA.TCORBAObject");
            this.add(", ".concat(String.valueOf(def.pascalFullName)));
        } else {
            this.add(((PInterfaceNode)def._bases.elementAt((int)0)).pascalStubFullName);
            for (int i = 1; i < def._bases.size(); ++i) {
                this.add(", ".concat(String.valueOf(def.pascalBases[i].pascalFullName)));
            }
            this.add(", ".concat(String.valueOf(def.pascalFullName)));
        }
        this.addln(")");
    }

    private void writeTypecodeSequenceDefaultElement(PUnionNode def, int k) {
        this.println(String.valueOf(new StringBuffer("Seq[").append(k).append("].Member_Name := '").append(def.pascalMemberNames[def._defaultIndex]).append("';")));
        this.println(String.valueOf(new StringBuffer("Seq[").append(k).append("].Member_Label:= ").append(def.pascalDefaultDescValue).append(";")));
        this.print(String.valueOf(new StringBuffer("Seq[").append(k).append("].Member_TC   := ")));
        if (def.pascalMemberTkHelperFullNames[def._defaultIndex] != null) {
            this.addln(String.valueOf(def.pascalMemberTkHelperFullNames[def._defaultIndex]).concat(".TypeCode;"));
        } else {
            this.addln(String.valueOf(new StringBuffer("ORB.CreateTC(Integer(").append(def.pascalMemberTkNames[def._defaultIndex]).append("));")));
        }
    }

    private void writeTypecodeSequenceElement(PUnionNode def, int i, int j, int k) {
        this.println(String.valueOf(new StringBuffer("Seq[").append(k).append("].Member_Name := '").append(def.pascalMemberNames[i]).append("';")));
        this.println(String.valueOf(new StringBuffer("Seq[").append(k).append("].Member_Label:= ").append(def.pascalMemberLabels[i][j]).append(";")));
        this.print(String.valueOf(new StringBuffer("Seq[").append(k).append("].Member_TC   := ")));
        if (def.pascalMemberTkHelperFullNames[i] != null) {
            this.addln(String.valueOf(def.pascalMemberTkHelperFullNames[i]).concat(".TypeCode;"));
        } else {
            this.addln(String.valueOf(new StringBuffer("ORB.CreateTC(Integer(").append(def.pascalMemberTkNames[i]).append("));")));
        }
    }

    private final void writeUsedUnits(int pass, PModuleNode def) {
        int _unitCount = 0;
        Enumeration e = null;
        this.usePascalUnitUnitsUsedBuffer(pass, def);
        this.indent(pass, 1);
        switch (pass) {
            case 0: {
                if (def.pascalCorbaUnitRequired) {
                    this.print(pass, "CORBA");
                    _unitCount = (short)(_unitCount + 1);
                }
                e = def.pascalIFileUnitsUsedByInterfaceSection.elements();
                break;
            }
            case 1: {
                this.println(pass, "CORBA,");
                this.print(pass, def.pascalIUnitName);
                _unitCount = (short)(_unitCount + 2);
                e = def.pascalCFileUnitsUsedByInterfaceSection.elements();
                break;
            }
            case 2: {
                this.println(pass, "CORBA,");
                this.println(pass, String.valueOf(def.pascalIUnitName).concat(","));
                this.print(pass, def.pascalCUnitName);
                e = def.pascalSFileUnitsUsedByInterfaceSection.elements();
                _unitCount = (short)(_unitCount + 3);
                break;
            }
            case 3: {
                this.println(pass, "SysUtils,");
                this.println(pass, "CORBA,");
                this.println(pass, String.valueOf(def.pascalIUnitName).concat(","));
                this.print(pass, def.pascalCUnitName);
                e = def.pascalPFileUnitsUsedByInterfaceSection.elements();
                _unitCount = (short)(_unitCount + 4);
            }
        }
        if (e != null) {
            while (e.hasMoreElements()) {
                int n = _unitCount;
                _unitCount = (short)(n + 1);
                if (n > 0) {
                    this.addln(",");
                }
                this.print(pass, e.nextElement().toString());
                _unitCount = (short)(_unitCount + 1);
            }
        }
        if (_unitCount > 0) {
            this.addln(pass, ";");
        }
        this.indent(pass, -1);
    }

    private final void writeUsedUnits(int pass, PRepositoryNode def) {
        this.usePascalUnitUnitsUsedBuffer(pass, def);
        int _unitCount = 0;
        Enumeration e = null;
        this.indent(1);
        switch (pass) {
            case 0: {
                if (def.pascalCorbaUnitRequired) {
                    this.print("CORBA");
                    _unitCount = (short)(_unitCount + 1);
                }
                e = def.pascalIFileUnitsUsedByInterfaceSection.elements();
                break;
            }
            case 1: {
                this.println("CORBA,");
                this.print(def.pascalIUnitName);
                _unitCount = (short)(_unitCount + 2);
                e = def.pascalCFileUnitsUsedByInterfaceSection.elements();
                break;
            }
            case 2: {
                this.println("CORBA,");
                this.println(String.valueOf(def.pascalIUnitName).concat(","));
                this.print(def.pascalCUnitName);
                _unitCount = (short)(_unitCount + 3);
                e = def.pascalSFileUnitsUsedByInterfaceSection.elements();
                break;
            }
            case 3: {
                this.println("SysUtils,");
                this.println("CORBA,");
                this.println(String.valueOf(def.pascalIUnitName).concat(","));
                this.print(pass, def.pascalCUnitName);
                _unitCount = (short)(_unitCount + 4);
                e = def.pascalPFileUnitsUsedByInterfaceSection.elements();
            }
        }
        if (e != null) {
            while (e.hasMoreElements()) {
                int n = _unitCount;
                _unitCount = (short)(n + 1);
                if (n > 0) {
                    this.addln(",");
                }
                this.print(e.nextElement().toString());
                _unitCount = (short)(_unitCount + 1);
            }
        }
        if (_unitCount > 0) {
            this.addln(";");
        }
        this.indent(-1);
    }

    private final void writeUsedUnits2(int pass, PModuleNode def) {
        this.usePascalUnitUnitsUsed2Buffer(pass, def);
        Enumeration e = null;
        int _unitCount = 0;
        this.indent(1);
        switch (pass) {
            case 0: {
                break;
            }
            case 1: {
                e = def.pascalCFileUnitsUsedByImplementationSection.elements();
                break;
            }
            case 2: {
                e = def.pascalSFileUnitsUsedByImplementationSection.elements();
                break;
            }
            case 3: {
                e = def.pascalPFileUnitsUsedByImplementationSection.elements();
            }
        }
        if (e != null) {
            while (e.hasMoreElements()) {
                int n = _unitCount;
                _unitCount = (short)(n + 1);
                if (n > 0) {
                    this.addln(",");
                }
                this.print(e.nextElement().toString());
                _unitCount = (short)(_unitCount + 1);
            }
        }
        if (_unitCount > 0) {
            this.addln(";");
        }
        this.indent(-1);
    }

    private final void writeUsedUnits2(int pass, PRepositoryNode def) {
        this.usePascalUnitUnitsUsed2Buffer(pass, def);
        Enumeration e = null;
        int _unitCount = 0;
        this.indent(1);
        switch (pass) {
            case 0: {
                break;
            }
            case 1: {
                e = def.pascalCFileUnitsUsedByImplementationSection.elements();
                break;
            }
            case 2: {
                e = def.pascalSFileUnitsUsedByImplementationSection.elements();
                break;
            }
            case 3: {
                e = def.pascalPFileUnitsUsedByImplementationSection.elements();
            }
        }
        if (e != null) {
            while (e.hasMoreElements()) {
                int n = _unitCount;
                _unitCount = (short)(n + 1);
                if (n > 0) {
                    this.addln(",");
                }
                this.print(e.nextElement().toString());
                _unitCount = (short)(_unitCount + 1);
            }
        }
        if (_unitCount > 0) {
            this.addln(";");
        }
        this.indent(-1);
    }

    private final void writeUserComments(int pass, PModuleNode pModule) {
        this.writePreambleComments(pass, pModule._repository.ER().getFileName(pModule._fileNumber));
        this.newLine(pass);
        this.writeFileComments(pass, pModule.pascalName, pModule.pascalIUnitName, pModule.pascalCUnitName, pModule.pascalSUnitName, pModule.pascalPUnitName);
    }

    private final void writeUserComments(int pass, PRepositoryNode pRepository) {
        this.writePreambleComments(pass, pRepository.pascalFileName);
        this.newLine(pass);
        this.writeFileComments(pass, "default", pRepository.pascalIUnitName, pRepository.pascalCUnitName, pRepository.pascalSUnitName, pRepository.pascalPUnitName);
    }

    private void writeWriteElement(PUnionNode def) {
        this.print("else ");
        if (this.needsRangeCheck(def.pascalMemberTypes[def._defaultIndex])) {
            this.println("begin");
        }
        this.writeWriteRangeCheck(def.pascalMemberTypes[def._defaultIndex], "_Value.".concat(String.valueOf(def.pascalMemberNames[def._defaultIndex])), def.pascalFullName, true, false);
        if (def.pascalMemberHelperFullNames[def._defaultIndex] != null) {
            this.println(String.valueOf(new StringBuffer(String.valueOf(def.pascalMemberHelperFullNames[def._defaultIndex])).append(".Write(_Output, _Value.").append(def.pascalMemberNames[def._defaultIndex]).append(");")));
        } else {
            this.println(String.valueOf(new StringBuffer("_Output.Write").append(def.pascalMemberReadWritePrefixes[def._defaultIndex]).append("(_Value.").append(def.pascalMemberNames[def._defaultIndex]).append(");")));
        }
        if (this.needsRangeCheck(def.pascalMemberTypes[def._defaultIndex])) {
            this.println("end;");
        }
    }

    private void writeWriteElement(PUnionNode def, int i, int j) {
        this.print(String.valueOf(def.pascalMemberLabels[i][j]).concat(" : "));
        if (this.needsRangeCheck(def.pascalMemberTypes[i])) {
            this.println("begin");
        }
        this.writeWriteRangeCheck(def.pascalMemberTypes[i], "_Value.".concat(String.valueOf(def.pascalMemberNames[i])), def.pascalFullName, true, false);
        if (def.pascalMemberHelperFullNames[i] != null) {
            this.addln(String.valueOf(new StringBuffer(String.valueOf(def.pascalMemberHelperFullNames[i])).append(".Write(_Output, _Value.").append(def.pascalMemberNames[i]).append(");")));
        } else {
            this.addln(String.valueOf(new StringBuffer("_Output.Write").append(def.pascalMemberReadWritePrefixes[i]).append("(_Value.").append(def.pascalMemberNames[i]).append(");")));
        }
        if (this.needsRangeCheck(def.pascalMemberTypes[i])) {
            this.println("end;");
        }
    }

    private void writeWriteRangeCheck(Type type, String variableName, String name) {
        this.writeWriteRangeCheck(type, variableName, name, false, true);
    }

    private void writeWriteRangeCheck(Type type, String variableName, String name, boolean continueLine, boolean newLine) {
        if (this.needsRangeCheck(type)) {
            if (!continueLine) {
                this.print("");
            }
            this.add(String.valueOf(new StringBuffer("if (").append(variableName).append(" < 0) then raise DATA_CONVERSION.Create(0, COMPLETED_NO);")));
            if (newLine) {
                this.newLine();
            } else {
                this.add(" ");
            }
        }
    }
}

